/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.DevServerWatchDog;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevModeHandler
implements RequestHandler {
    private static final String START_FAILURE = "Couldn't start dev server because";
    private static final AtomicReference<DevModeHandler> atomicHandler = new AtomicReference();
    private static final String DEFAULT_OUTPUT_PATTERN = ": Compiled.";
    private static final String DEFAULT_ERROR_PATTERN = ": Failed to compile.";
    private static final String FAILED_MSG = "\n------------------ Frontend compilation failed. ------------------\n\n";
    private static final String SUCCEED_MSG = "\n----------------- Frontend compiled successfully. -----------------\n\n";
    private static final String START = "\n------------------ Starting Frontend compilation. ------------------\n";
    private static final String END = "\n------------------------- Webpack stopped  -------------------------\n";
    private static final String LOG_START = "Running webpack to compile frontend resources. This may take a moment, please stand by...";
    private static final String LOG_END = "Started webpack-dev-server. Time: {}ms";
    private static final String DEFAULT_TIMEOUT_FOR_PATTERN = "60000";
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final String WEBPACK_HOST = "http://localhost";
    private boolean notified = false;
    private volatile String failedOutput;
    private AtomicBoolean isDevServerFailedToStart = new AtomicBoolean();
    private transient BrowserLiveReload liveReload;
    public static final String WEBPACK_SERVER = "node_modules/webpack-dev-server/bin/webpack-dev-server.js";
    private static final String WEBPACK_PORTFILE_UUID_PROPERTY = "vaadin.frontend.webpack.portfile.uuid";
    private volatile int port;
    private final AtomicReference<Process> webpackProcess = new AtomicReference();
    private final boolean reuseDevServer;
    private final AtomicReference<DevServerWatchDog> watchDog = new AtomicReference();
    private final File devServerPortFile;
    private volatile List<String> manifestPaths = new ArrayList<String>();
    private StringBuilder cumulativeOutput = new StringBuilder();
    private final CompletableFuture<Void> devServerStartFuture;
    private final File npmFolder;

    private DevModeHandler(Lookup lookup, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        this.npmFolder = npmFolder;
        this.port = runningPort;
        ApplicationConfiguration config = lookup.lookup(ApplicationConfiguration.class);
        this.reuseDevServer = config.reuseDevServer();
        this.devServerPortFile = DevModeHandler.getDevServerPortFile(npmFolder);
        BiConsumer<Void, Throwable> action = (value, exception) -> {
            waitFor.getNow(null);
            this.runOnFutureComplete(config);
        };
        this.devServerStartFuture = waitFor.whenCompleteAsync((BiConsumer)action);
    }

    public static DevModeHandler start(Lookup lookup, File npmFolder, CompletableFuture<Void> waitFor) {
        return DevModeHandler.start(0, lookup, npmFolder, waitFor);
    }

    public static DevModeHandler start(int runningPort, Lookup lookup, File npmFolder, CompletableFuture<Void> waitFor) {
        ApplicationConfiguration configuration = lookup.lookup(ApplicationConfiguration.class);
        if (configuration.isProductionMode() || !configuration.enableDevServer()) {
            return null;
        }
        if (atomicHandler.get() == null) {
            atomicHandler.compareAndSet(null, DevModeHandler.createInstance(runningPort, lookup, npmFolder, waitFor));
        }
        return DevModeHandler.getDevModeHandler();
    }

    public static DevModeHandler getDevModeHandler() {
        return atomicHandler.get();
    }

    public void setLiveReload(BrowserLiveReload liveReload) {
        this.liveReload = liveReload;
    }

    public BrowserLiveReload getLiveReload() {
        return this.liveReload;
    }

    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (this.devServerStartFuture.isDone()) {
            try {
                this.devServerStartFuture.getNow(null);
            }
            catch (CompletionException exception) {
                this.isDevServerFailedToStart.set(true);
                throw this.getCause(exception);
            }
            return false;
        }
        InputStream inputStream = DevModeHandler.class.getResourceAsStream("dev-mode-not-ready.html");
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        response.setContentType("text/html;charset=utf-8");
        return true;
    }

    private RuntimeException getCause(Throwable exception) {
        if (exception instanceof CompletionException) {
            return this.getCause(exception.getCause());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new IllegalStateException(exception);
    }

    private static DevModeHandler createInstance(int runningPort, Lookup lookup, File npmFolder, CompletableFuture<Void> waitFor) {
        return new DevModeHandler(lookup, runningPort, npmFolder, waitFor);
    }

    public boolean isDevModeRequest(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && (pathInfo.startsWith("/VAADIN/") || StaticFileServer.APP_THEME_PATTERN.matcher(pathInfo).find()) && !pathInfo.startsWith("/VAADIN/dynamic/resource/")) {
            return true;
        }
        return this.manifestPaths.contains(pathInfo);
    }

    public boolean serveDevModeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isDevServerFailedToStart.get() || !this.devServerStartFuture.isDone()) {
            return false;
        }
        String requestFilename = request.getPathInfo();
        if (HandlerHelper.isPathUnsafe(requestFilename)) {
            DevModeHandler.getLogger().info("Blocked attempt to access file: {}", (Object)requestFilename);
            response.setStatus(403);
            return true;
        }
        if (StaticFileServer.APP_THEME_PATTERN.matcher(requestFilename).find()) {
            requestFilename = "/VAADIN/static" + requestFilename;
        }
        HttpURLConnection connection = this.prepareConnection(requestFilename, request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header2;
            connection.setRequestProperty(header2, "Connect".equals(header2 = (String)headerNames.nextElement()) ? "close" : request.getHeader(header2));
        }
        DevModeHandler.getLogger().debug("Requesting resource to webpack {}", (Object)connection.getURL());
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            DevModeHandler.getLogger().debug("Resource not served by webpack {}", (Object)requestFilename);
            return false;
        }
        DevModeHandler.getLogger().debug("Served resource by webpack: {} {}", (Object)responseCode, (Object)requestFilename);
        connection.getHeaderFields().forEach((header, values) -> {
            if (header != null) {
                response.addHeader(header, (String)values.get(0));
            }
        });
        if (responseCode == 200) {
            this.writeStream(response.getOutputStream(), connection.getInputStream());
        } else if (responseCode < 400) {
            response.setStatus(responseCode);
        } else {
            response.sendError(responseCode);
        }
        response.getOutputStream().close();
        return true;
    }

    private boolean checkWebpackConnection() {
        try {
            this.readManifestPaths();
            return true;
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("Error checking webpack dev server connection", (Throwable)e);
            return false;
        }
    }

    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        URL uri = new URL("http://localhost:" + this.getPort() + path);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestMethod(method);
        connection.setReadTimeout(120000);
        connection.setConnectTimeout(120000);
        return connection;
    }

    private synchronized void doNotify() {
        if (!this.notified) {
            this.notified = true;
            this.notifyAll();
        }
    }

    private void logStream(InputStream input, Pattern success, Pattern failure) {
        Thread thread = new Thread(() -> {
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            try {
                this.readLinesLoop(success, failure, reader);
            }
            catch (IOException e) {
                if ("Stream closed".equals(e.getMessage())) {
                    FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", END);
                    DevModeHandler.getLogger().debug("Exception when reading webpack output.", (Throwable)e);
                }
                DevModeHandler.getLogger().error("Exception when reading webpack output.", (Throwable)e);
            }
            this.doNotify();
        });
        thread.setDaemon(true);
        thread.setName("webpack");
        thread.start();
    }

    private void readLinesLoop(Pattern success, Pattern failure, InputStreamReader reader) throws IOException {
        int i;
        StringBuilder line = new StringBuilder();
        while ((i = reader.read()) >= 0) {
            char ch = (char)i;
            FrontendUtils.console("%c", Character.valueOf(ch));
            line.append(ch);
            if (ch != '\n') continue;
            this.processLine(line.toString(), success, failure);
            line.setLength(0);
        }
    }

    private void processLine(String line, Pattern success, Pattern failure) {
        if (line.contains("\b")) {
            return;
        }
        String cleanLine = line.replaceAll("(\u001b\\[[;\\d]*m|[\b\r]+)", "");
        this.cumulativeOutput.append(cleanLine);
        boolean succeed = success.matcher(line).find();
        boolean failed = failure.matcher(line).find();
        if (succeed || failed) {
            if (succeed) {
                FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", SUCCEED_MSG);
            } else {
                FrontendUtils.console("\u001b[38;5;196m%s\u001b[0m", FAILED_MSG);
            }
            this.failedOutput = failed ? this.cumulativeOutput.toString() : null;
            this.cumulativeOutput = new StringBuilder();
            try {
                this.readManifestPaths();
            }
            catch (IOException e) {
                DevModeHandler.getLogger().error("Error when reading manifest.json from webpack-dev-server", (Throwable)e);
            }
            this.doNotify();
            if (this.liveReload != null) {
                this.liveReload.reload();
            }
        }
    }

    private void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[32768];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeHandler.class);
    }

    public String getFailedOutput() {
        return this.failedOutput;
    }

    public void removeRunningDevServerPort() {
        FileUtils.deleteQuietly((File)this.devServerPortFile);
    }

    private void runOnFutureComplete(ApplicationConfiguration config) {
        try {
            this.doStartDevModeServer(config);
        }
        catch (ExecutionFailedException exception) {
            DevModeHandler.getLogger().error(null, (Throwable)exception);
            throw new CompletionException(exception);
        }
    }

    private void readManifestPaths() throws IOException {
        DevModeHandler.getLogger().debug("Reading manifest.json from webpack");
        HttpURLConnection connection = this.prepareConnection("/manifest.json", "GET");
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            DevModeHandler.getLogger().error("Unable to get manifest.json from webpack-dev-server, got {} {}", (Object)responseCode, (Object)connection.getResponseMessage());
            return;
        }
        String manifestJson = FrontendUtils.streamToString(connection.getInputStream());
        this.manifestPaths = FrontendUtils.parseManifestPaths(manifestJson);
        if (DevModeHandler.getLogger().isDebugEnabled()) {
            DevModeHandler.getLogger().debug("Got asset paths from webpack manifest.json: \n    {}", (Object)String.join((CharSequence)"\n    ", this.manifestPaths));
        }
    }

    private void saveRunningDevServerPort() {
        try {
            FileUtils.writeStringToFile((File)this.devServerPortFile, (String)String.valueOf(this.port), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkPort() {
        if (this.checkWebpackConnection()) {
            DevModeHandler.getLogger().info("Reusing webpack-dev-server running at {}:{}", (Object)WEBPACK_HOST, (Object)this.port);
            this.saveRunningDevServerPort();
            this.watchDog.set(null);
            return false;
        }
        throw new IllegalStateException(String.format("%s webpack-dev-server port '%d' is defined but it's not working properly", START_FAILURE, this.port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDevModeServer(ApplicationConfiguration config) throws ExecutionFailedException {
        if (this.port > 0) {
            if (!this.checkWebpackConnection()) {
                throw new IllegalStateException(String.format("%s webpack-dev-server port '%d' is defined but it's not working properly", START_FAILURE, this.port));
            }
            this.reuseExistingPort(this.port);
            return;
        }
        this.port = DevModeHandler.getRunningDevServerPort(this.npmFolder);
        if (this.port > 0) {
            if (this.checkWebpackConnection()) {
                this.reuseExistingPort(this.port);
                return;
            }
            DevModeHandler.getLogger().warn("webpack-dev-server port '%d' is defined but it's not working properly. Using a new free port...", (Object)this.port);
            this.port = 0;
        }
        Pair<File, File> webPackFiles = this.validateFiles(this.npmFolder);
        long start = System.nanoTime();
        DevModeHandler.getLogger().info("Starting webpack-dev-server");
        this.watchDog.set(new DevServerWatchDog());
        this.port = DevModeHandler.getFreePort();
        this.saveRunningDevServerPort();
        boolean success = false;
        try {
            success = this.doStartWebpack(config, webPackFiles, start);
        }
        finally {
            if (!success) {
                this.removeRunningDevServerPort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStartWebpack(ApplicationConfiguration config, Pair<File, File> webPackFiles, long start) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.npmFolder);
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        FrontendTools tools = new FrontendTools(this.npmFolder.getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), useHomeNodeExec);
        tools.validateNodeAndNpmVersion();
        String nodeExec = null;
        nodeExec = useHomeNodeExec ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        List<String> command = this.makeCommands(config, webPackFiles.getFirst(), webPackFiles.getSecond(), nodeExec);
        FrontendUtils.console("\u001b[38;5;35m%s\u001b[0m", START);
        if (DevModeHandler.getLogger().isDebugEnabled()) {
            DevModeHandler.getLogger().debug(FrontendUtils.commandToString(this.npmFolder.getAbsolutePath(), command));
        }
        processBuilder.command(command);
        try {
            this.webpackProcess.set(processBuilder.redirectError(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start());
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
            Pattern succeed = Pattern.compile(config.getStringProperty("devmode.webpack.output.success.pattern", DEFAULT_OUTPUT_PATTERN));
            Pattern failure = Pattern.compile(config.getStringProperty("devmode.webpack.output.error.pattern", DEFAULT_ERROR_PATTERN));
            this.logStream(this.webpackProcess.get().getInputStream(), succeed, failure);
            DevModeHandler.getLogger().info(LOG_START);
            DevModeHandler devModeHandler = this;
            synchronized (devModeHandler) {
                this.wait(Integer.parseInt(config.getStringProperty("devmode.webpack.output.pattern.timeout", DEFAULT_TIMEOUT_FOR_PATTERN)));
            }
            if (!this.webpackProcess.get().isAlive()) {
                throw new IllegalStateException("Webpack exited prematurely");
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            DevModeHandler.getLogger().info(LOG_END, (Object)ms);
            return true;
        }
        catch (IOException e) {
            DevModeHandler.getLogger().error("Failed to start the webpack process", (Throwable)e);
        }
        catch (InterruptedException e) {
            DevModeHandler.getLogger().debug("Webpack process start has been interrupted", (Throwable)e);
        }
        return false;
    }

    private void reuseExistingPort(int port) {
        DevModeHandler.getLogger().info("Reusing webpack-dev-server running at {}:{}", (Object)WEBPACK_HOST, (Object)port);
        this.saveRunningDevServerPort();
        this.watchDog.set(null);
    }

    private List<String> makeCommands(ApplicationConfiguration config, File webpack, File webpackConfig, String nodeExec) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeExec);
        command.add(webpack.getAbsolutePath());
        command.add("--config");
        command.add(webpackConfig.getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.port));
        command.add("--watchDogPort=" + this.watchDog.get().getWatchDogPort());
        command.addAll(Arrays.asList(config.getStringProperty("devmode.webpack.options", "-d --inline=false").split(" +")));
        return command;
    }

    private Pair<File, File> validateFiles(File npmFolder) throws ExecutionFailedException {
        assert (this.port == 0);
        File webpack = new File(npmFolder, WEBPACK_SERVER);
        File webpackConfig = new File(npmFolder, "webpack.config.js");
        if (!npmFolder.exists()) {
            DevModeHandler.getLogger().warn("No project folder '{}' exists", (Object)npmFolder);
            throw new ExecutionFailedException("Couldn't start dev server because the target execution folder doesn't exist.");
        }
        if (!webpack.exists()) {
            DevModeHandler.getLogger().warn("'{}' doesn't exist. Did you run `npm install`?", (Object)webpack);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist. `npm install` has not run or failed.", START_FAILURE, webpack));
        }
        if (!webpack.canExecute()) {
            DevModeHandler.getLogger().warn(" '{}' is not an executable. Did you run `npm install`?", (Object)webpack);
            throw new ExecutionFailedException(String.format("%s '%s' is not an executable. `npm install` has not run or failed.", START_FAILURE, webpack));
        }
        if (!webpackConfig.canRead()) {
            DevModeHandler.getLogger().warn("Webpack configuration '{}' is not found or is not readable.", (Object)webpackConfig);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist or is not readable.", START_FAILURE, webpackConfig));
        }
        return new Pair<File, File>(webpack, webpackConfig);
    }

    private static int getRunningDevServerPort(File npmFolder) {
        int port = 0;
        File portFile = DevModeHandler.getDevServerPortFile(npmFolder);
        if (portFile.canRead()) {
            try {
                String portString = FileUtils.readFileToString((File)portFile, (Charset)StandardCharsets.UTF_8).trim();
                if (!portString.isEmpty()) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getFreePort() {
        try (ServerSocket s = new ServerSocket(0);){
            s.setReuseAddress(true);
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find a free port for running webpack", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean reuseDevServer() {
        return this.reuseDevServer;
    }

    public void stop() {
        Process process;
        if (atomicHandler.get() == null) {
            return;
        }
        try {
            this.prepareConnection("/stop", "GET").getResponseCode();
        }
        catch (IOException e) {
            DevModeHandler.getLogger().debug("webpack-dev-server does not support the `/stop` command.", (Throwable)e);
        }
        DevServerWatchDog watchDogInstance = this.watchDog.get();
        if (watchDogInstance != null) {
            watchDogInstance.stop();
        }
        if ((process = this.webpackProcess.get()) != null && process.isAlive()) {
            process.destroy();
        }
        atomicHandler.set(null);
        this.removeRunningDevServerPort();
    }

    void join() {
        this.devServerStartFuture.join();
    }

    private static File getDevServerPortFile(File npmFolder) {
        String jvmUuid = System.getProperty(WEBPACK_PORTFILE_UUID_PROPERTY);
        if (jvmUuid == null) {
            jvmUuid = UUID.randomUUID().toString();
            System.setProperty(WEBPACK_PORTFILE_UUID_PROPERTY, jvmUuid);
        }
        String frontendBuildPath = npmFolder.getAbsolutePath();
        String uniqueUid = UUID.nameUUIDFromBytes((jvmUuid + frontendBuildPath).getBytes(StandardCharsets.UTF_8)).toString();
        return new File(System.getProperty("java.io.tmpdir"), uniqueUid);
    }
}

