/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import elemental.json.JsonObject;
import java.util.Optional;

public class AttachExistingElementRpcHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "attachExistingElement";
    }

    @Override
    protected Optional<Runnable> handleNode(StateNode node, JsonObject invocationJson) {
        assert (invocationJson.hasKey("attachReqId"));
        assert (invocationJson.hasKey("attachAssignedId"));
        assert (invocationJson.hasKey("attachTagName"));
        assert (invocationJson.hasKey("attachIndex"));
        int requestedId = (int)invocationJson.getNumber("attachReqId");
        int assignedId = (int)invocationJson.getNumber("attachAssignedId");
        String tag = invocationJson.getString("attachTagName");
        int index = (int)invocationJson.getNumber("attachIndex");
        AttachExistingElementFeature feature = node.getFeature(AttachExistingElementFeature.class);
        StateTree tree = (StateTree)node.getOwner();
        StateNode requestedNode = tree.getNodeById(requestedId);
        if (assignedId == -1) {
            assert (index == -1);
            ChildElementConsumer callback = feature.getCallback(requestedNode);
            assert (callback != null);
            callback.onError(feature.getParent(requestedNode), tag, feature.getPreviousSibling(requestedNode));
            feature.unregister(requestedNode);
        } else {
            Element element = Element.get(tree.getNodeById(assignedId));
            this.attachElement(feature, element, index, tree.getNodeById(requestedId), requestedId == assignedId);
        }
        return Optional.empty();
    }

    private void attachElement(AttachExistingElementFeature feature, Element element, int index, StateNode node, boolean insertChild) {
        ChildElementConsumer callback = feature.getCallback(node);
        if (callback != null) {
            Node<?> parent = feature.getParent(node);
            feature.unregister(node);
            if (insertChild) {
                parent.insertChild(index, element);
            }
            callback.accept(element);
        }
    }
}

