/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ResponseWriter;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileServer
implements StaticFileHandler {
    static final String PROPERTY_FIX_INCORRECT_WEBJAR_PATHS = "vaadin.fixIncorrectWebjarPaths";
    private static final Pattern INCORRECT_WEBJAR_PATH_REGEX = Pattern.compile("^/frontend[-\\w/]*/webjars/");
    private final ResponseWriter responseWriter;
    private final VaadinService vaadinService;
    private DeploymentConfiguration deploymentConfiguration;
    private final List<String> manifestPaths;
    protected static final Pattern APP_THEME_PATTERN = Pattern.compile("^\\/themes\\/[\\s\\S]+?\\/");
    static final Map<URI, Integer> openFileSystems = new HashMap<URI, Integer>();
    private static final Object fileSystemLock = new Object();

    public StaticFileServer(VaadinService vaadinService) {
        this.vaadinService = vaadinService;
        this.deploymentConfiguration = vaadinService.getDeploymentConfiguration();
        this.responseWriter = new ResponseWriter(this.deploymentConfiguration);
        this.manifestPaths = this.getManifestPathsFromJson();
    }

    @Override
    public boolean isStaticResourceRequest(HttpServletRequest request) {
        String requestFilename = this.getRequestFilename(request);
        if (requestFilename.endsWith("/")) {
            return false;
        }
        if (APP_THEME_PATTERN.matcher(requestFilename).find() || requestFilename.startsWith("/VAADIN/static/") || requestFilename.startsWith("/VAADIN/build/")) {
            return true;
        }
        if (this.manifestPaths.contains(requestFilename)) {
            return true;
        }
        URL resource = this.getStaticResource(requestFilename);
        if (resource != null && this.resourceIsDirectory(resource)) {
            return false;
        }
        if (resource == null && this.shouldFixIncorrectWebjarPaths() && this.isIncorrectWebjarPath(requestFilename)) {
            return true;
        }
        return resource != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourceIsDirectory(URL resource) {
        if (resource.getPath().endsWith("/")) {
            return true;
        }
        URI resourceURI = null;
        try {
            resourceURI = resource.toURI();
        }
        catch (URISyntaxException e) {
            StaticFileServer.getLogger().debug("Syntax error in uri from getStaticResource", (Throwable)e);
            return false;
        }
        if ("jar".equals(resource.getProtocol())) {
            String pathInJar = resource.getPath().substring(resource.getPath().lastIndexOf("!") + 1);
            try {
                FileSystem fileSystem = this.getFileSystem(resourceURI);
                Path path = fileSystem.getPath(pathInJar, new String[0]);
                boolean bl = Files.isDirectory(path, new LinkOption[0]);
                return bl;
            }
            catch (IOException e) {
                StaticFileServer.getLogger().debug("failed to read zip file", (Throwable)e);
            }
            finally {
                this.closeFileSystem(resourceURI);
            }
        }
        return "file".equals(resource.getProtocol()) && Files.isDirectory(Paths.get(resourceURI), new LinkOption[0]);
    }

    private URI getFileURI(URI resourceURI) {
        if (!"jar".equals(resourceURI.getScheme())) {
            return resourceURI;
        }
        try {
            String scheme = resourceURI.getRawSchemeSpecificPart();
            int jarPartIndex = scheme.indexOf("!/");
            if (jarPartIndex != -1) {
                scheme = scheme.substring(0, jarPartIndex);
            }
            return new URI(scheme);
        }
        catch (URISyntaxException syntaxException) {
            throw new IllegalArgumentException(syntaxException.getMessage(), syntaxException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileSystem getFileSystem(URI resourceURI) throws IOException {
        Object object = fileSystemLock;
        synchronized (object) {
            URI fileURI = this.getFileURI(resourceURI);
            if (openFileSystems.computeIfPresent(fileURI, (key, value) -> value + 1) != null) {
                return FileSystems.getFileSystem(resourceURI);
            }
            FileSystem fileSystem = FileSystems.newFileSystem(resourceURI, Collections.emptyMap());
            openFileSystems.put(fileURI, 1);
            return fileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFileSystem(URI resourceURI) {
        Object object = fileSystemLock;
        synchronized (object) {
            try {
                URI fileURI = this.getFileURI(resourceURI);
                Integer locks = openFileSystems.computeIfPresent(fileURI, (key, value) -> value - 1);
                if (locks != null && locks == 0) {
                    openFileSystems.remove(fileURI);
                    FileSystems.getFileSystem(resourceURI).close();
                }
            }
            catch (IOException ioe) {
                StaticFileServer.getLogger().error("Failed to close FileSystem for '{}'", (Object)resourceURI);
                StaticFileServer.getLogger().debug("Exception closing FileSystem", (Throwable)ioe);
            }
        }
    }

    @Override
    public boolean serveStaticResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filenameWithPath = this.getRequestFilename(request);
        if (HandlerHelper.isPathUnsafe(filenameWithPath)) {
            StaticFileServer.getLogger().info("Blocked attempt to access file: {}", (Object)filenameWithPath);
            response.setStatus(403);
            return true;
        }
        URL resourceUrl = null;
        if (this.isAllowedVAADINBuildOrStaticUrl(filenameWithPath) || this.manifestPaths.contains(filenameWithPath)) {
            resourceUrl = APP_THEME_PATTERN.matcher(filenameWithPath).find() ? this.vaadinService.getClassLoader().getResource("META-INF/VAADIN/webapp/VAADIN/static/" + filenameWithPath.replaceFirst("^/", "")) : this.vaadinService.getClassLoader().getResource("META-INF/VAADIN/webapp/" + filenameWithPath.replaceFirst("^/", ""));
        }
        if (resourceUrl == null) {
            resourceUrl = this.getStaticResource(filenameWithPath);
        }
        if (resourceUrl == null && this.shouldFixIncorrectWebjarPaths() && this.isIncorrectWebjarPath(filenameWithPath)) {
            resourceUrl = this.getStaticResource(this.fixIncorrectWebjarPath(filenameWithPath));
        }
        if (resourceUrl == null) {
            response.sendError(404);
            return true;
        }
        this.writeCacheHeaders(filenameWithPath, response);
        long timestamp = this.writeModificationTimestamp(resourceUrl, request, response);
        if (this.browserHasNewestVersion(request, timestamp)) {
            response.setStatus(304);
            return true;
        }
        this.responseWriter.writeResponseContents(filenameWithPath, resourceUrl, request, response);
        return true;
    }

    protected URL getStaticResource(String path) {
        return this.vaadinService.getStaticResource(path);
    }

    private boolean shouldFixIncorrectWebjarPaths() {
        return this.deploymentConfiguration.isProductionMode() && this.deploymentConfiguration.getBooleanProperty(PROPERTY_FIX_INCORRECT_WEBJAR_PATHS, false);
    }

    private boolean isIncorrectWebjarPath(String requestFilename) {
        return INCORRECT_WEBJAR_PATH_REGEX.matcher(requestFilename).lookingAt();
    }

    private String fixIncorrectWebjarPath(String requestFilename) {
        return INCORRECT_WEBJAR_PATH_REGEX.matcher(requestFilename).replaceAll("/webjars/");
    }

    private boolean isAllowedVAADINBuildOrStaticUrl(String filenameWithPath) {
        return filenameWithPath.startsWith("/VAADIN/build/") || filenameWithPath.startsWith("/VAADIN/static/") || APP_THEME_PATTERN.matcher(filenameWithPath).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long writeModificationTimestamp(URL resourceUrl, HttpServletRequest request, HttpServletResponse response) {
        URLConnection connection = null;
        try {
            connection = resourceUrl.openConnection();
            long lastModifiedTime = connection.getLastModified();
            lastModifiedTime -= lastModifiedTime % 1000L;
            response.setDateHeader("Last-Modified", lastModifiedTime);
            long l = lastModifiedTime;
            return l;
        }
        catch (Exception e) {
            StaticFileServer.getLogger().trace("Failed to find out last modified timestamp. Continuing without it.", (Throwable)e);
        }
        finally {
            try {
                InputStream is;
                if (connection != null && (is = connection.getInputStream()) != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                StaticFileServer.getLogger().warn("Error closing URLConnection input stream", (Throwable)e);
            }
        }
        return -1L;
    }

    protected void writeCacheHeaders(String filenameWithPath, HttpServletResponse response) {
        int resourceCacheTime = this.getCacheTime(filenameWithPath);
        String cacheControl = !this.deploymentConfiguration.isProductionMode() ? "no-cache" : (resourceCacheTime > 0 ? "max-age=" + resourceCacheTime : "public, max-age=0, must-revalidate");
        response.setHeader("Cache-Control", cacheControl);
    }

    String getRequestFilename(HttpServletRequest request) {
        if (request.getPathInfo() == null) {
            return request.getServletPath();
        }
        if (request.getPathInfo().startsWith("/VAADIN/") || APP_THEME_PATTERN.matcher(request.getPathInfo()).find()) {
            return request.getPathInfo();
        }
        return request.getServletPath() + request.getPathInfo();
    }

    protected int getCacheTime(String filenameWithPath) {
        if (filenameWithPath.contains(".nocache.")) {
            return 0;
        }
        if (filenameWithPath.contains(".cache.")) {
            return 31536000;
        }
        return 3600;
    }

    protected boolean browserHasNewestVersion(HttpServletRequest request, long resourceLastModifiedTimestamp) {
        assert (resourceLastModifiedTimestamp >= -1L);
        if (resourceLastModifiedTimestamp == -1L) {
            return false;
        }
        try {
            long headerIfModifiedSince = request.getDateHeader("If-Modified-Since");
            if (headerIfModifiedSince >= resourceLastModifiedTimestamp) {
                return true;
            }
        }
        catch (Exception e) {
            StaticFileServer.getLogger().trace("Unable to parse If-Modified-Since", (Throwable)e);
        }
        return false;
    }

    private List<String> getManifestPathsFromJson() {
        InputStream stream = this.vaadinService.getClassLoader().getResourceAsStream("META-INF/VAADIN/webapp/manifest.json");
        if (stream == null) {
            return new ArrayList<String>();
        }
        return FrontendUtils.parseManifestPaths(FrontendUtils.streamToString(stream));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StaticFileServer.class.getName());
    }
}

