/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccess;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHtmlRequestHandler
extends JavaScriptBootstrapHandler {
    private static final String CONTENT_ATTRIBUTE = "content";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SPRING_CSRF_TOKEN_ATTRIBUTE_IN_SESSION = "org.springframework.security.web.csrf.CsrfToken";
    private static final String SPRING_CSRF_HEADER_PROPERTY = "headerName";
    private static final String SPRING_CSRF_PARAMETER_PROPERTY = "parameterName";
    private static final String SPRING_CSRF_TOKEN_PROPERTY = "token";
    private static final String SPRING_CSRF_PARAMETER_NAME_ATTRIBUTE = "_csrf_parameter";
    private static final String SPRING_CSRF_HEADER_NAME_ATTRIBUTE = "_csrf_header";
    private static final String SPRING_CSRF_TOKEN_ATTRIBUTE = "_csrf";
    private static final String META_TAG = "meta";

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        IndexHtmlResponse indexHtmlResponse;
        DeploymentConfiguration config = session.getConfiguration();
        Document indexDocument = config.isProductionMode() ? IndexHtmlRequestHandler.getCachedIndexHtmlDocument(request.getService()) : IndexHtmlRequestHandler.getIndexHtmlDocument(request.getService());
        IndexHtmlRequestHandler.prependBaseHref(request, indexDocument);
        JsonObject initialJson = Json.createObject();
        if (request.getService().getBootstrapInitialPredicate().includeInitialUidl(request)) {
            this.includeInitialUidl(initialJson, session, request, response);
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument, UI.getCurrent());
            session.setAttribute("clientRoutingMode", Boolean.TRUE);
        } else {
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument);
        }
        this.addInitialFlow(initialJson, indexDocument, session, request);
        this.configureErrorDialogStyles(indexDocument);
        IndexHtmlRequestHandler.showWebpackErrors(indexDocument);
        response.setContentType("text/html; charset=utf-8");
        VaadinContext context = session.getService().getContext();
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        if (!config.isProductionMode()) {
            UsageStatisticsExporter.exportUsageStatisticsToDocument(indexDocument);
        }
        IndexHtmlRequestHandler.setupPwa(indexDocument, session.getService());
        registry.modifyIndexHtml(indexDocument, request);
        this.storeAppShellTitleToUI(indexDocument);
        request.getService().modifyIndexHtmlResponse(indexHtmlResponse);
        if (config.isDevModeLiveReloadEnabled()) {
            this.addDevmodeGizmo(indexDocument, session, request);
        }
        try {
            response.getOutputStream().write(indexDocument.html().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            IndexHtmlRequestHandler.getLogger().error("Error writing 'index.html' to response", (Throwable)e);
            return false;
        }
        return true;
    }

    private void storeAppShellTitleToUI(Document indexDocument) {
        Element elm;
        if (UI.getCurrent() != null && (elm = indexDocument.head().selectFirst("title")) != null) {
            String appShellTitle = elm.text().isEmpty() ? elm.data() : elm.text();
            UI.getCurrent().getInternals().setAppShellTitle(appShellTitle);
        }
    }

    private void addDevmodeGizmo(Document indexDocument, VaadinSession session, VaadinRequest request) {
        BrowserLiveReload liveReload;
        VaadinService service = session.getService();
        BrowserLiveReloadAccess liveReloadAccess = service.getInstantiator().getOrCreate(BrowserLiveReloadAccess.class);
        BrowserLiveReload browserLiveReload = liveReload = liveReloadAccess != null ? liveReloadAccess.getLiveReload(service) : null;
        if (liveReload != null) {
            Element devmodeGizmo = new Element("vaadin-devmode-gizmo");
            devmodeGizmo.attr("url", BootstrapHandlerHelper.getPushURL(session, request));
            if (liveReload.getBackend() != null) {
                devmodeGizmo.attr("backend", liveReload.getBackend().toString());
            }
            devmodeGizmo.attr("springbootlivereloadport", Integer.toString(35729));
            indexDocument.body().appendChild((Node)devmodeGizmo);
        }
    }

    private void addInitialFlow(JsonObject initialJson, Document indexDocument, VaadinSession session, VaadinRequest request) {
        String referer = request.getHeader("referer");
        if (referer == null || !referer.endsWith("/sw.js")) {
            JsonObject springCsrfTokenJson;
            Object springCsrfToken;
            String csrfToken = session.getCsrfToken();
            if (csrfToken != null) {
                initialJson.put("csrfToken", csrfToken);
            }
            if ((springCsrfToken = request.getAttribute(SPRING_CSRF_TOKEN_ATTRIBUTE_IN_SESSION)) != null && (springCsrfTokenJson = JsonUtils.beanToJson(springCsrfToken)) != null && springCsrfTokenJson.hasKey(SPRING_CSRF_TOKEN_PROPERTY) && springCsrfTokenJson.hasKey(SPRING_CSRF_HEADER_PROPERTY)) {
                String springCsrfTokenString = springCsrfTokenJson.getString(SPRING_CSRF_TOKEN_PROPERTY);
                String springCsrfTokenHeaderName = springCsrfTokenJson.getString(SPRING_CSRF_HEADER_PROPERTY);
                String springCsrfTokenParameterName = springCsrfTokenJson.getString(SPRING_CSRF_PARAMETER_PROPERTY);
                this.addMetaTagToHead(indexDocument.head(), SPRING_CSRF_TOKEN_ATTRIBUTE, springCsrfTokenString);
                this.addMetaTagToHead(indexDocument.head(), SPRING_CSRF_HEADER_NAME_ATTRIBUTE, springCsrfTokenHeaderName);
                this.addMetaTagToHead(indexDocument.head(), SPRING_CSRF_PARAMETER_NAME_ATTRIBUTE, springCsrfTokenParameterName);
            }
        }
        Element elm = new Element("script");
        elm.attr("initial", "");
        elm.appendChild((Node)new DataNode("window.Vaadin = {TypeScript: " + JsonUtil.stringify((JsonValue)initialJson) + "};"));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void addMetaTagToHead(Element head, String name, String value) {
        Element meta = new Element(META_TAG);
        meta.attr(NAME_ATTRIBUTE, name);
        meta.attr(CONTENT_ATTRIBUTE, value);
        head.insertChildren(0, new Node[]{meta});
    }

    private void includeInitialUidl(JsonObject initialJson, VaadinSession session, VaadinRequest request, VaadinResponse response) {
        JsonObject initial = this.getInitialJson(request, response, session);
        initialJson.put("initial", (JsonValue)initial);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return !BootstrapHandler.isFrameworkInternalRequest(request) && request.getService().getBootstrapUrlPredicate().isValidUrl(request);
    }

    @Override
    protected void initializeUIWithRouter(BootstrapHandler.BootstrapContext context, UI ui) {
        if (context.getService().getBootstrapInitialPredicate().includeInitialUidl(context.getRequest())) {
            ui.getInternals().getRouter().initializeUI(ui, context.getRoute());
        }
    }

    private void configureErrorDialogStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupErrorDialogs(styles);
    }

    private static void prependBaseHref(VaadinRequest request, Document indexDocument) {
        Elements base = indexDocument.head().getElementsByTag("base");
        String baseHref = IndexHtmlRequestHandler.getServiceUrl(request);
        if (base.isEmpty()) {
            indexDocument.head().prependElement("base").attr("href", baseHref);
        } else {
            base.first().attr("href", baseHref);
        }
    }

    private static Document getCachedIndexHtmlDocument(VaadinService service) {
        return service.getContext().getAttribute(IndexHtmlHolder.class, () -> new IndexHtmlHolder(service)).getDocument();
    }

    private static Document getIndexHtmlDocument(VaadinService service) throws IOException {
        String index = FrontendUtils.getIndexHtmlContent(service);
        if (index != null) {
            return Jsoup.parse((String)index);
        }
        String frontendDir = FrontendUtils.getProjectFrontendDir(service.getDeploymentConfiguration());
        String indexHtmlFilePath = frontendDir.endsWith("/") || frontendDir.endsWith(File.separator) ? frontendDir + "index.html" : (frontendDir.contains(File.separator) ? frontendDir + File.separatorChar + "index.html" : frontendDir + "/index.html");
        String message = String.format("Failed to load content of '%1$s'. It is required to have '%1$s' file when using client side bootstrapping.", indexHtmlFilePath);
        throw new IOException(message);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IndexHtmlRequestHandler.class);
    }

    private static final class IndexHtmlHolder
    implements Serializable {
        private final transient Document indexHtmlDocument;

        private IndexHtmlHolder(VaadinService service) {
            try {
                this.indexHtmlDocument = IndexHtmlRequestHandler.getIndexHtmlDocument(service);
                this.indexHtmlDocument.outputSettings().prettyPrint(false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Document getDocument() {
            return this.indexHtmlDocument.clone();
        }
    }
}

