/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;

public class TaskGenerateBootstrap
extends AbstractTaskClientGenerator {
    private final FrontendDependenciesScanner frontDeps;
    private final File connectClientTsApiFolder;
    private final File frontendDirectory;
    private final String buildDirectory;

    TaskGenerateBootstrap(FrontendDependenciesScanner frontDeps, File frontendDirectory, String buildDirectory) {
        this.frontDeps = frontDeps;
        this.frontendDirectory = frontendDirectory;
        this.connectClientTsApiFolder = new File(frontendDirectory, "generated/");
        this.buildDirectory = buildDirectory;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("import '%s';%n", this.getIndexTsEntryPath()));
        lines.addAll(this.getThemeLines());
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.connectClientTsApiFolder, "vaadin.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return this.frontDeps != null;
    }

    private String getIndexTsEntryPath() {
        boolean exists = new File(this.frontendDirectory, "index.ts").exists() || new File(this.frontendDirectory, "index.js").exists();
        Path path = exists ? Paths.get(this.frontendDirectory.getPath(), "index.ts") : Paths.get(this.frontendDirectory.getParentFile().getPath(), this.buildDirectory, "index.ts");
        String relativePath = FrontendUtils.getUnixRelativePath(this.connectClientTsApiFolder.toPath(), path);
        return relativePath.replaceFirst("\\.[tj]s$", "");
    }

    private Collection<String> getThemeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.shouldApplyAppTheme()) {
            lines.add("import { applyTheme } from './theme';");
            lines.add("applyTheme(document);");
            lines.add("");
        }
        return lines;
    }

    private boolean shouldApplyAppTheme() {
        ThemeDefinition themeDef = this.frontDeps.getThemeDefinition();
        return themeDef != null && !"".equals(themeDef.getName());
    }
}

