/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.QueryParameters;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Location
implements Serializable {
    private static final String PATH_SEPARATOR = "/";
    private static final String QUERY_SEPARATOR = "?";
    private final List<String> segments;
    private final QueryParameters queryParameters;

    public Location(String location) {
        this(Location.parsePath(Location.ensureRelativeNonNull(location), true), Location.parseParams(Location.ensureRelativeNonNull(location)));
    }

    private static String ensureRelativeNonNull(String location) {
        if (location == null) {
            return "";
        }
        if (location.startsWith(PATH_SEPARATOR)) {
            location = location.substring(1);
        }
        return location.trim();
    }

    public Location(String location, QueryParameters queryParameters) {
        this(Location.parsePath(Location.ensureRelativeNonNull(location), false), queryParameters);
    }

    public Location(List<String> segments) {
        this(segments, QueryParameters.empty());
    }

    public Location(List<String> segments, QueryParameters queryParameters) {
        if (segments == null) {
            throw new IllegalArgumentException("Segments cannot be null");
        }
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one segment");
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException("Query parameters cannot be null");
        }
        this.segments = segments;
        this.queryParameters = queryParameters;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public String getFirstSegment() {
        return this.segments.get(0);
    }

    public Optional<Location> getSubLocation() {
        List<String> subSegments = this.segments.subList(1, this.segments.size());
        if (subSegments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Location(subSegments, this.queryParameters));
    }

    public String getPath() {
        return this.segments.stream().collect(Collectors.joining(PATH_SEPARATOR));
    }

    public String getPathWithQueryParameters() {
        String basePath = this.getPath();
        assert (!basePath.contains(QUERY_SEPARATOR)) : "Base path can not contain query separator=?";
        String params = this.queryParameters.getQueryString();
        if (params.isEmpty()) {
            return basePath;
        }
        return basePath + QUERY_SEPARATOR + params;
    }

    public Location toggleTrailingSlash() {
        assert (!this.segments.isEmpty());
        String lastSegment = this.segments.get(this.segments.size() - 1);
        if (this.segments.size() == 1 && "".equals(lastSegment)) {
            throw new IllegalArgumentException("Can't toggle ending slash for the \"\" location");
        }
        if (lastSegment.isEmpty()) {
            return new Location(this.segments.subList(0, this.segments.size() - 1), this.queryParameters);
        }
        ArrayList<String> newSegments = new ArrayList<String>(this.segments);
        newSegments.add("");
        return new Location(newSegments, this.queryParameters);
    }

    private static QueryParameters parseParams(String path) {
        String query;
        int beginIndex = path.indexOf(QUERY_SEPARATOR);
        if (beginIndex < 0) {
            return QueryParameters.empty();
        }
        try {
            query = new URI(path).getQuery();
        }
        catch (URISyntaxException ignore) {
            query = null;
        }
        if (query == null) {
            query = path.substring(beginIndex + 1);
        }
        return QueryParameters.fromString(query);
    }

    private static List<String> parsePath(String path, boolean stripQueryString) {
        int endIndex = path.indexOf(QUERY_SEPARATOR);
        String basePath = stripQueryString && endIndex >= 0 ? path.substring(0, endIndex) : path;
        Location.verifyRelativePath(basePath);
        List<String> splitList = Arrays.asList(basePath.split(PATH_SEPARATOR));
        if (basePath.endsWith(PATH_SEPARATOR)) {
            ArrayList<String> result = new ArrayList<String>(splitList.size() + 1);
            result.addAll(splitList);
            result.add("");
            return result;
        }
        return splitList;
    }

    private static void verifyRelativePath(String path) {
        assert (path != null);
        try {
            String strippedPath = path.replaceAll("[{}*]", "");
            URI uri = new URI(URLEncoder.encode(strippedPath, StandardCharsets.UTF_8.name()));
            if (uri.isAbsolute()) {
                throw new IllegalArgumentException("Relative path cannot contain an URI scheme");
            }
            if (uri.getPath().startsWith(PATH_SEPARATOR)) {
                throw new IllegalArgumentException("Relative path cannot start with /");
            }
            if (Location.hasIncorrectParentSegments(uri.getRawPath())) {
                throw new IllegalArgumentException("Relative path cannot contain .. segments");
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new IllegalArgumentException("Cannot parse path: " + path, e);
        }
    }

    private static boolean hasIncorrectParentSegments(String path) {
        if (path.startsWith("..%2F")) {
            return true;
        }
        if (path.contains("%2F..%2F")) {
            return true;
        }
        if (path.endsWith("%2F..")) {
            return true;
        }
        return path.equals("..");
    }
}

