/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.server.ErrorRouteRegistry;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.NavigationTargetFilter;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class ApplicationRouteRegistry
extends AbstractRouteRegistry
implements ErrorRouteRegistry {
    private AtomicReference<Class<?>> pwaConfigurationClass = new AtomicReference();
    private final ArrayList<NavigationTargetFilter> routeFilters = new ArrayList();

    protected ApplicationRouteRegistry() {
        ServiceLoader.load(NavigationTargetFilter.class).forEach(this.routeFilters::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationRouteRegistry getInstance(VaadinContext context) {
        ApplicationRouteRegistryWrapper attribute;
        assert (context != null);
        VaadinContext vaadinContext = context;
        synchronized (vaadinContext) {
            attribute = context.getAttribute(ApplicationRouteRegistryWrapper.class);
            if (attribute == null) {
                attribute = new ApplicationRouteRegistryWrapper(ApplicationRouteRegistry.createRegistry(context));
                context.setAttribute(attribute);
            }
        }
        return attribute.getRegistry();
    }

    @Override
    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        if (this.routeFilters.stream().allMatch(filter -> filter.testNavigationTarget(navigationTarget))) {
            super.setRoute(path, navigationTarget, parentChain);
        } else {
            LoggerFactory.getLogger(ApplicationRouteRegistry.class).info("Not registering route {} because it's not valid for all registered routeFilters.", (Object)navigationTarget.getName());
        }
    }

    public void setErrorNavigationTargets(Set<Class<? extends Component>> errorNavigationTargets) {
        HashMap<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap = new HashMap<Class<? extends Exception>, Class<? extends Component>>();
        exceptionTargetsMap.putAll(this.getConfiguration().getExceptionHandlers());
        errorNavigationTargets.stream().filter(this::allErrorFiltersMatch).filter(handler -> !Modifier.isAbstract(handler.getModifiers())).forEach(target -> this.addErrorTarget((Class<? extends Component>)target, (Map<Class<? extends Exception>, Class<? extends Component>>)exceptionTargetsMap));
        this.initErrorTargets(exceptionTargetsMap);
    }

    private boolean allErrorFiltersMatch(Class<? extends Component> target) {
        return this.routeFilters.stream().allMatch(filter -> filter.testErrorNavigationTarget(target));
    }

    @Override
    public Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
        Optional<ErrorTargetEntry> result;
        if (this.getConfiguration().getExceptionHandlers().isEmpty()) {
            this.initErrorTargets(new HashMap<Class<? extends Exception>, Class<? extends Component>>());
        }
        if (!(result = this.searchByCause(exception)).isPresent()) {
            result = this.searchBySuperType(exception);
        }
        return result;
    }

    public boolean hasNavigationTargets() {
        return !this.getConfiguration().getRoutes().isEmpty();
    }

    public Class<?> getPwaConfigurationClass() {
        return this.pwaConfigurationClass.get();
    }

    public void setPwaConfigurationClass(Class<?> pwaClass) {
        if (pwaClass != null && pwaClass.isAnnotationPresent(PWA.class)) {
            this.pwaConfigurationClass.set(pwaClass);
        }
    }

    protected void handleInitializedRegistry() {
        throw new IllegalStateException("Route registry has been already initialized");
    }

    private void initErrorTargets(Map<Class<? extends Exception>, Class<? extends Component>> map) {
        if (!map.containsKey(NotFoundException.class)) {
            map.put(NotFoundException.class, RouteNotFoundError.class);
        }
        if (!map.containsKey(Exception.class)) {
            map.put(Exception.class, InternalServerError.class);
        }
        this.configure(configuration -> map.forEach(configuration::setErrorRoute));
    }

    private static ApplicationRouteRegistry createRegistry(VaadinContext context) {
        return new ApplicationRouteRegistry();
    }

    protected static class ApplicationRouteRegistryWrapper
    implements Serializable {
        private final ApplicationRouteRegistry registry;

        public ApplicationRouteRegistryWrapper(ApplicationRouteRegistry registry) {
            this.registry = registry;
        }

        public ApplicationRouteRegistry getRegistry() {
            return this.registry;
        }
    }
}

