/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;

public final class StringUtil {
    public static final String removeComments(String code) {
        State state = State.NORMAL;
        StringBuilder result = new StringBuilder();
        HashMap<String, Character> replacements = new HashMap<String, Character>();
        Scanner scanner = new Scanner(StringUtil.normalize(code, replacements));
        scanner.useDelimiter("");
        while (scanner.hasNext()) {
            String character = scanner.next();
            switch (state) {
                case NORMAL: {
                    if (character.equals("/") && scanner.hasNext()) {
                        String nextCharacter = scanner.next();
                        if (nextCharacter.equals("/")) {
                            state = State.IN_LINE_COMMENT;
                            break;
                        }
                        if (nextCharacter.equals("*")) {
                            state = State.IN_BLOCK_COMMENT;
                            break;
                        }
                        result.append(character).append(nextCharacter);
                        break;
                    }
                    result.append(character);
                    if (!character.equals("\"")) break;
                    state = State.IN_STRING;
                    break;
                }
                case IN_STRING: {
                    result.append(character);
                    if (character.equals("\"")) {
                        state = State.NORMAL;
                        break;
                    }
                    if (!character.equals("\\") || !scanner.hasNext()) break;
                    result.append(scanner.next());
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (!character.equals("\n")) break;
                    result.append(character);
                    state = State.NORMAL;
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    if (!character.equals("*") || !scanner.hasNext("/")) break;
                    scanner.next();
                    state = State.NORMAL;
                }
            }
        }
        scanner.close();
        String handled = result.toString();
        for (Map.Entry entry : replacements.entrySet()) {
            handled = handled.replace((CharSequence)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return handled;
    }

    private static String normalize(String str, Map<String, Character> replacements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!Character.isHighSurrogate(ch) && !Character.isLowSurrogate(ch)) {
                builder.append(str.charAt(i));
                continue;
            }
            String replacement = StringUtil.generateReplacement(str);
            replacements.put(replacement, Character.valueOf(ch));
            builder.append(replacement);
        }
        return builder.toString();
    }

    private static String generateReplacement(String str) {
        String replacement = UUID.randomUUID().toString();
        if (str.contains(replacement)) {
            return StringUtil.generateReplacement(str);
        }
        return replacement;
    }

    private static enum State {
        NORMAL,
        IN_LINE_COMMENT,
        IN_BLOCK_COMMENT,
        IN_STRING;

    }
}

