/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.internal.Template;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyTemplateFiles
implements FallibleCommand {
    private final ClassFinder classFinder;
    private final File projectDirectory;
    private final File resourceOutputDirectory;

    TaskCopyTemplateFiles(ClassFinder classFinder, File projectDirectory, File resourceOutputDirectory) {
        this.classFinder = classFinder;
        this.projectDirectory = projectDirectory;
        this.resourceOutputDirectory = resourceOutputDirectory;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        HashSet<Class<Template>> classes = new HashSet<Class<Template>>();
        classes.addAll(this.classFinder.getSubTypesOf(Template.class));
        for (Class clazz : classes) {
            for (JsModule jsmAnnotation : (JsModule[])clazz.getAnnotationsByType(JsModule.class)) {
                String path = jsmAnnotation.value();
                File source = FrontendUtils.resolveFrontendPath(this.projectDirectory, path);
                if (source == null) {
                    throw new ExecutionFailedException("Unable to locate file " + path);
                }
                File templateDirectory = new File(this.resourceOutputDirectory, "config/templates/");
                File target = new File(templateDirectory, path).getParentFile();
                target.mkdirs();
                try {
                    FileUtils.copyFileToDirectory((File)source, (File)target);
                }
                catch (IOException e) {
                    throw new ExecutionFailedException(e);
                }
            }
        }
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

