/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.webcomponent.WebComponentExporterTagExtractor;
import com.vaadin.flow.server.webcomponent.WebComponentExporterUtils;
import com.vaadin.flow.server.webcomponent.WebComponentGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public final class WebComponentModulesWriter
implements Serializable {
    private WebComponentModulesWriter() {
    }

    private static Set<File> writeWebComponentsToDirectory(Set<Class<?>> exporterClasses, File outputDirectory, boolean compatibilityMode, String themeName) {
        Objects.requireNonNull(exporterClasses, "Parameter 'exporterClasses' must not be null");
        Objects.requireNonNull(outputDirectory, "Parameter 'outputDirectory' must not be null");
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Path provided by parameter 'outputDirectory' (%s) is not a directory", outputDirectory.getPath()));
        }
        return WebComponentExporterUtils.getFactories(exporterClasses).stream().map(factory -> WebComponentModulesWriter.writeWebComponentToDirectory(factory, outputDirectory, compatibilityMode, themeName)).collect(Collectors.toSet());
    }

    private static File writeWebComponentToDirectory(WebComponentExporterFactory<?> factory, File outputDirectory, boolean compatibilityMode, String themeName) {
        String tag = WebComponentModulesWriter.getTag(factory);
        String fileName = compatibilityMode ? tag + ".html" : tag + ".js";
        Path generatedFile = outputDirectory.toPath().resolve(fileName);
        try {
            FileUtils.forceMkdir((File)generatedFile.getParent().toFile());
            Files.write(generatedFile, Collections.singletonList(WebComponentModulesWriter.generateModule(factory, compatibilityMode, themeName)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create web component module file '%s'", generatedFile), e);
        }
        return generatedFile.toFile();
    }

    private static String generateModule(WebComponentExporterFactory<? extends Component> factory, boolean compatibilityMode, String themeName) {
        return WebComponentGenerator.generateModule(factory, "../", compatibilityMode, themeName);
    }

    private static String getTag(WebComponentExporterFactory<? extends Component> factory) {
        WebComponentExporterTagExtractor exporterTagExtractor = new WebComponentExporterTagExtractor();
        return exporterTagExtractor.apply(factory);
    }

    public static final class DirectoryWriter
    implements Serializable {
        public static Set<File> generateWebComponentsToDirectory(Set<Class<?>> exporterClasses, File outputDirectory, boolean compatibilityMode, String themeName) {
            Objects.requireNonNull(exporterClasses, "Parameter 'exporterClasses' must not be null");
            Objects.requireNonNull(outputDirectory, "Parameter 'outputDirectory' must not be null");
            ClassLoader writerClassLoader = WebComponentModulesWriter.class.getClassLoader();
            for (Class<?> exporterClass : exporterClasses) {
                ClassLoader exporterClassLoader = exporterClass.getClassLoader();
                if (ReflectTools.findClosestCommonClassLoaderAncestor(writerClassLoader, exporterClassLoader).isPresent()) continue;
                String writerClassLoaderName = writerClassLoader == null ? "null" : writerClassLoader.getClass().getName();
                String exporterClassLoaderName = exporterClassLoader == null ? "null" : exporterClassLoader.getClass().getName();
                throw new IllegalArgumentException(String.format("Supplied writer '%s' and supplied exporter '%s' have different class loaders, '%s' and '%s', respectively. Writer and exporters must share a class loader.", WebComponentModulesWriter.class.getName(), exporterClass.getName(), writerClassLoaderName, exporterClassLoaderName));
            }
            return WebComponentModulesWriter.writeWebComponentsToDirectory(exporterClasses, outputDirectory, compatibilityMode, themeName);
        }
    }
}

