/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.RouteParameterRegex;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteFormat;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class HasUrlParameterFormat
implements Serializable {
    public static final String PARAMETER_NAME = "___url_parameter";
    public static final String PARAMETER = ":___url_parameter";

    private HasUrlParameterFormat() {
    }

    public static String getTemplate(String urlBase, Class<? extends Component> navigationTarget) {
        if (HasUrlParameterFormat.hasUrlParameter(navigationTarget)) {
            urlBase = PathUtil.trimPath(urlBase);
            urlBase = HasUrlParameterFormat.hasOptionalParameter(navigationTarget) ? urlBase + "/:___url_parameter?" : (HasUrlParameterFormat.hasWildcardParameter(navigationTarget) ? urlBase + "/:___url_parameter*" : urlBase + "/:___url_parameter");
            Class<?> parameterType = ParameterDeserializer.getClassType(navigationTarget);
            if (!String.class.equals(parameterType)) {
                urlBase = urlBase + "(" + RouteParameterRegex.getRegex(parameterType) + ")";
            }
        }
        return urlBase;
    }

    public static String getUrlBase(String template) {
        if (RouteFormat.hasParameters(template)) {
            return PathUtil.trimPath(template.substring(0, template.indexOf(58)));
        }
        return template;
    }

    public static <T> String getUrl(String url, List<T> parameters) {
        return PathUtil.getPath(url, parameters.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public static <T> RouteParameters getParameters(T parameter) {
        List<String> segments;
        if (parameter == null) {
            return RouteParameters.empty();
        }
        if (parameter instanceof String && (segments = PathUtil.getSegmentsList((String)parameter)).size() > 1) {
            return HasUrlParameterFormat.getParameters(segments);
        }
        return new RouteParameters(Collections.singletonMap(PARAMETER_NAME, parameter.toString()));
    }

    public static <T> RouteParameters getParameters(List<T> parametersList) {
        if (parametersList.size() == 1) {
            return HasUrlParameterFormat.getParameters(parametersList.get(0));
        }
        RouteParameters result = parametersList.isEmpty() ? RouteParameters.empty() : new RouteParameters(Collections.singletonMap(PARAMETER_NAME, parametersList.stream().map(Object::toString).collect(Collectors.joining("/"))));
        return result;
    }

    public static List<String> getParameterValues(RouteParameters parameters) {
        Optional<String> value;
        List<String> wildcard = parameters.getWildcard(PARAMETER_NAME);
        if (wildcard.isEmpty() && (value = parameters.get(PARAMETER_NAME)).isPresent()) {
            wildcard = Collections.singletonList(value.get());
        }
        return wildcard;
    }

    public static List<Class<?>> getParameterTypes(Collection<String> types) {
        return types.stream().map(RouteParameterRegex::getType).collect(Collectors.toList());
    }

    public static void checkMandatoryParameter(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        if (HasUrlParameterFormat.hasUrlParameter(navigationTarget) && HasUrlParameterFormat.hasMandatoryParameter(navigationTarget) && (parameters == null || !parameters.get(PARAMETER_NAME).isPresent())) {
            throw new IllegalArgumentException(String.format("Navigation target '%s' requires a parameter.", navigationTarget.getName()));
        }
    }

    static boolean hasUrlParameter(Class<? extends Component> target) {
        return HasUrlParameter.class.isAssignableFrom(target);
    }

    static boolean hasMandatoryParameter(Class<? extends Component> target) {
        return !HasUrlParameterFormat.hasOptionalParameter(target) && !HasUrlParameterFormat.hasWildcardParameter(target);
    }

    static boolean hasOptionalParameter(Class<? extends Component> target) {
        return ParameterDeserializer.isAnnotatedParameter(target, OptionalParameter.class);
    }

    static boolean hasWildcardParameter(Class<? extends Component> target) {
        return ParameterDeserializer.isAnnotatedParameter(target, WildcardParameter.class);
    }
}

