/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.server.frontend.FrontendVersion;

public class Platform {
    private final OS os;
    private final Architecture architecture;
    private static final int NODE_VERSION_THRESHOLD_MAC_ARM64 = 16;

    public Platform(OS os, Architecture architecture) {
        this.os = os;
        this.architecture = architecture;
    }

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        return new Platform(os, architecture);
    }

    public String getArchiveExtension() {
        return this.os.getArchiveExtension();
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.WINDOWS;
    }

    public boolean isMac() {
        return this.os == OS.MAC;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public OS getOs() {
        return this.os;
    }

    public String getNodeClassifier(FrontendVersion nodeVersion) {
        return this.getCodename() + "-" + this.resolveArchitecture(nodeVersion).getName();
    }

    private Architecture resolveArchitecture(FrontendVersion nodeVersion) {
        Integer nodeMajorVersion;
        if (this.isMac() && this.architecture == Architecture.ARM64 && ((nodeMajorVersion = Integer.valueOf(nodeVersion.getMajorVersion())) == null || nodeMajorVersion < 16)) {
            return Architecture.X64;
        }
        return this.architecture;
    }

    static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        SUN_OS;


        public static OS guess() {
            String osName = System.getProperty("os.name");
            return osName.contains("Windows") ? WINDOWS : (osName.contains("Mac") ? MAC : (osName.contains("SunOS") ? SUN_OS : LINUX));
        }

        public String getArchiveExtension() {
            if (this == WINDOWS) {
                return "zip";
            }
            return "tar.gz";
        }

        public String getCodename() {
            if (this == MAC) {
                return "darwin";
            }
            if (this == WINDOWS) {
                return "win";
            }
            if (this == SUN_OS) {
                return "sunos";
            }
            return "linux";
        }
    }

    static enum Architecture {
        X86,
        X64,
        PPC64LE,
        S390X,
        ARM64,
        ARMV7L;


        public static Architecture guess() {
            String arch = System.getProperty("os.arch");
            String version = System.getProperty("os.version");
            if ("ppc64le".equals(arch)) {
                return PPC64LE;
            }
            if ("aarch64".equals(arch)) {
                return ARM64;
            }
            if ("s390x".equals(arch)) {
                return S390X;
            }
            if ("arm".equals(arch) && version.contains("v7")) {
                return ARMV7L;
            }
            return arch.contains("64") ? X64 : X86;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

