/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.nio.charset.StandardCharsets;

public final class EncodeUtil {
    private EncodeUtil() {
    }

    public static String rfc5987Encode(String value) {
        int cp;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); i += Character.charCount(cp)) {
            cp = value.codePointAt(i);
            if (cp < 127 && (Character.isLetterOrDigit(cp) || cp == 46)) {
                builder.append((char)cp);
                continue;
            }
            String cpAsString = new String(new int[]{cp}, 0, 1);
            EncodeUtil.appendHexBytes(builder, cpAsString.getBytes(StandardCharsets.UTF_8));
        }
        return builder.toString();
    }

    private static void appendHexBytes(StringBuilder builder, byte[] bytes) {
        for (byte byteValue : bytes) {
            int intValue = byteValue & 0xFF;
            String hexCode = Integer.toString(intValue, 16);
            builder.append('%').append(hexCode);
        }
    }
}

