/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.InitialPageSettings;
import com.vaadin.flow.server.InlineTargets;
import com.vaadin.flow.server.PageConfigurator;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.WebBrowser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class BootstrapUtils {
    private BootstrapUtils() {
    }

    static Optional<String> getViewportContent(BootstrapHandler.BootstrapContext context) {
        return context.getPageConfigurationAnnotation(Viewport.class).map(Viewport::value);
    }

    static Map<String, String> getMetaTargets(BootstrapHandler.BootstrapContext context) {
        List<Meta> metaAnnotations = context.getPageConfigurationAnnotations(Meta.class);
        boolean illegalValue = false;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Meta meta : metaAnnotations) {
            if (!meta.name().isEmpty() && !meta.content().isEmpty()) {
                map.put(meta.name(), meta.content());
                continue;
            }
            illegalValue = true;
            break;
        }
        if (illegalValue) {
            throw new IllegalStateException("Meta tags added via Meta annotation contain null value on name or content attribute.");
        }
        return map;
    }

    static Optional<InitialPageSettings> getInitialPageSettings(BootstrapHandler.BootstrapContext context) {
        UI ui = context.getUI();
        Optional<PageConfigurator> pageConfigurator = ui.getChildren().filter(component -> component instanceof PageConfigurator).map(component -> (PageConfigurator)((Object)component)).findFirst();
        if (pageConfigurator.isPresent()) {
            InitialPageSettings settings = BootstrapUtils.createInitialPageSettingsObject(context);
            pageConfigurator.get().configurePage(settings);
            return Optional.of(settings);
        }
        return Optional.empty();
    }

    private static InitialPageSettings createInitialPageSettingsObject(BootstrapHandler.BootstrapContext context) {
        UI ui = context.getUI();
        WebBrowser browser = context.getSession().getBrowser();
        Router router = ui.getInternals().getRouter();
        NavigationEvent navigationEvent = new NavigationEvent(router, context.getRoute(), ui, NavigationTrigger.PAGE_LOAD);
        List<HasElement> components = ui.getChildren().map(component -> component).collect(Collectors.toList());
        AfterNavigationEvent afterNavigationEvent = new AfterNavigationEvent(new LocationChangeEvent(navigationEvent.getSource(), navigationEvent.getUI(), navigationEvent.getTrigger(), navigationEvent.getLocation(), components));
        return new InitialPageSettings(context.getRequest(), ui, afterNavigationEvent, browser);
    }

    static String getBodySizeContent(BootstrapHandler.BootstrapContext context) {
        Optional<BodySize> bodySize = context.getPageConfigurationAnnotation(BodySize.class);
        String height = bodySize.map(BodySize::height).orElse("100vh");
        String width = bodySize.map(BodySize::width).orElse("100%");
        StringBuilder bodyString = new StringBuilder();
        bodyString.append("body {");
        if (!height.isEmpty()) {
            bodyString.append("height:").append(height).append(";");
        }
        if (!width.isEmpty()) {
            bodyString.append("width:").append(width).append(";");
        }
        bodyString.append("margin:0;");
        bodyString.append("}");
        return bodyString.toString();
    }

    static Optional<InlineTargets> getInlineTargets(BootstrapHandler.BootstrapContext context) {
        List<Inline> inlineAnnotations = context.getPageConfigurationAnnotations(Inline.class);
        if (inlineAnnotations.isEmpty()) {
            return Optional.empty();
        }
        InlineTargets inlines = new InlineTargets();
        inlineAnnotations.forEach(inline -> inlines.addInlineDependency((Inline)inline, context.getService()));
        return Optional.of(inlines);
    }

    /*
     * Exception decompiling
     */
    static String getDependencyContents(VaadinService service, String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream getInlineResourceStream(VaadinService service, String file) {
        ResourceProvider resourceProvider = service.getContext().getAttribute(Lookup.class).lookup(ResourceProvider.class);
        URL appResource = resourceProvider.getApplicationResource(file);
        InputStream stream = null;
        try {
            stream = appResource == null ? null : appResource.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Couldn't open application resource '%s' for inline resource", file), e);
        }
        if (stream == null) {
            throw new IllegalStateException(String.format("Application resource '%s' for inline resource is not available", file));
        }
        return stream;
    }

    @Deprecated
    public static Optional<Class<?>> resolvePageConfigurationHolder(UI ui, VaadinRequest request) {
        assert (ui != null);
        assert (request != null);
        Location route = new Location(request.getPathInfo(), QueryParameters.full(request.getParameterMap()));
        return BootstrapUtils.resolvePageConfigurationHolder(ui, route);
    }

    public static Optional<Class<?>> resolvePageConfigurationHolder(UI ui, Location route) {
        assert (ui != null);
        assert (route != null);
        if (ui.getInternals().getRouter() == null) {
            return Optional.empty();
        }
        Optional<Class<?>> navigationTarget = ui.getInternals().getRouter().resolveNavigationTarget(route).map(BootstrapUtils::resolveTopParentLayout);
        if (navigationTarget.isPresent()) {
            return navigationTarget;
        }
        return ui.getInternals().getRouter().resolveRouteNotFoundNavigationTarget().map(state -> {
            List<Class<? extends RouterLayout>> layouts = RouteUtil.getParentLayoutsForNonRouteTarget(state.getNavigationTarget());
            if (layouts.isEmpty()) {
                return state.getNavigationTarget();
            }
            return layouts.get(layouts.size() - 1);
        });
    }

    private static Class<?> resolveTopParentLayout(NavigationState navigationState) {
        Class<? extends RouterLayout> parentLayout = BootstrapUtils.getTopParentLayout(navigationState);
        if (parentLayout != null) {
            return parentLayout;
        }
        return navigationState.getNavigationTarget();
    }

    private static Class<? extends RouterLayout> getTopParentLayout(NavigationState navigationState) {
        List<Class<? extends RouterLayout>> routeLayouts = navigationState.getRouteTarget().getParentLayouts();
        if (routeLayouts.isEmpty()) {
            return null;
        }
        return routeLayouts.get(routeLayouts.size() - 1);
    }
}

