/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import java.io.Serializable;

public class ReconnectDialogConfigurationMap
extends NodeMap
implements ReconnectDialogConfiguration {
    public static final String DIALOG_TEXT_KEY = "dialogText";
    public static final String DIALOG_TEXT_DEFAULT = "Server connection lost, trying to reconnect...";
    public static final String DIALOG_TEXT_GAVE_UP_KEY = "dialogTextGaveUp";
    public static final String DIALOG_TEXT_GAVE_UP_DEFAULT = "Server connection lost.";
    public static final String RECONNECT_ATTEMPTS_KEY = "reconnectAttempts";
    public static final int RECONNECT_ATTEMPTS_DEFAULT = 10000;
    public static final String RECONNECT_INTERVAL_KEY = "reconnectInterval";
    public static final int RECONNECT_INTERVAL_DEFAULT = 5000;

    public ReconnectDialogConfigurationMap(StateNode node) {
        super(node);
    }

    @Override
    public String getDialogText() {
        return this.getOrDefault(DIALOG_TEXT_KEY, DIALOG_TEXT_DEFAULT);
    }

    @Override
    public void setDialogText(String dialogText) {
        this.put(DIALOG_TEXT_KEY, (Serializable)((Object)dialogText));
    }

    @Override
    public String getDialogTextGaveUp() {
        return this.getOrDefault(DIALOG_TEXT_GAVE_UP_KEY, DIALOG_TEXT_GAVE_UP_DEFAULT);
    }

    @Override
    public void setDialogTextGaveUp(String dialogTextGaveUp) {
        this.put(DIALOG_TEXT_GAVE_UP_KEY, (Serializable)((Object)dialogTextGaveUp));
    }

    @Override
    public int getReconnectAttempts() {
        return this.getOrDefault(RECONNECT_ATTEMPTS_KEY, 10000);
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.put(RECONNECT_ATTEMPTS_KEY, Integer.valueOf(reconnectAttempts));
    }

    @Override
    public int getReconnectInterval() {
        return this.getOrDefault(RECONNECT_INTERVAL_KEY, 5000);
    }

    @Override
    public void setReconnectInterval(int reconnectInterval) {
        this.put(RECONNECT_INTERVAL_KEY, Integer.valueOf(reconnectInterval));
    }
}

