/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;

public interface AbstractConfiguration
extends Serializable {
    public boolean isProductionMode();

    default public boolean enableDevServer() {
        return this.getBooleanProperty("enableDevServer", true);
    }

    default public boolean reuseDevServer() {
        return this.getBooleanProperty("reuseDevServer", true);
    }

    default public boolean useV14Bootstrap() {
        return this.getBooleanProperty("useDeprecatedV14Bootstrapping", false);
    }

    public String getStringProperty(String var1, String var2);

    public boolean getBooleanProperty(String var1, boolean var2);

    default public boolean isPnpmEnabled() {
        return this.getBooleanProperty("pnpm.enable", true);
    }

    default public boolean isGlobalPnpm() {
        return this.getBooleanProperty("pnpm.global", false);
    }

    default public boolean isUsageStatisticsEnabled() {
        return !this.isProductionMode() && this.getBooleanProperty("devmode.usageStatistics.enabled", true);
    }

    default public boolean isXsrfProtectionEnabled() {
        return !this.getBooleanProperty("disable-xsrf-protection", false);
    }

    default public String getBuildFolder() {
        return this.getStringProperty("build.folder", "target");
    }

    default public String getFlowResourcesFolder() {
        return Paths.get(this.getBuildFolder(), "flow-frontend").toString();
    }

    default public File getJavaResourceFolder() {
        return new File(this.getStringProperty("javaResourceFolder", "src/main/resources"));
    }
}

