/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import java.util.Enumeration;

public interface ApplicationConfiguration
extends AbstractConfiguration {
    public static ApplicationConfiguration get(VaadinContext context) {
        return context.getAttribute(ApplicationConfiguration.class, () -> {
            Lookup lookup = context.getAttribute(Lookup.class);
            if (lookup == null) {
                throw new IllegalStateException("The application " + Lookup.class.getSimpleName() + " instance is not found in the " + VaadinContext.class + " instance. It means that the container has not executed " + Lookup.class.getSimpleName() + " initialization code: so either the container is not Servlet 3.0 compatible or project configuration is broken.");
            }
            ApplicationConfigurationFactory factory = lookup.lookup(ApplicationConfigurationFactory.class);
            if (factory == null) {
                return null;
            }
            return factory.create(context);
        });
    }

    public Enumeration<String> getPropertyNames();

    public VaadinContext getContext();

    public FallbackChunk getFallbackChunk();

    public boolean isDevModeSessionSerializationEnabled();

    default public boolean disableAutomaticServletRegistration() {
        return this.getBooleanProperty("disable.automatic.servlet.registration", false);
    }
}

