/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.BodySize;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.Meta;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PageConfigurator;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinServletContextStartupInitializer;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={AppShellConfigurator.class, Meta.class, Meta.Container.class, PWA.class, Inline.class, Inline.Container.class, Viewport.class, BodySize.class, PageTitle.class, PageConfigurator.class, Push.class, Theme.class, NoTheme.class})
@WebListener
public class VaadinAppShellInitializer
implements VaadinServletContextStartupInitializer,
ServletContextListener,
Serializable {
    @Override
    public void initialize(Set<Class<?>> classes, VaadinContext context) {
        VaadinAppShellInitializer.init(classes, context);
    }

    @Deprecated
    public static void init(Set<Class<?>> classes, ServletContext context) {
        VaadinAppShellInitializer.init(classes, new VaadinServletContext(context));
    }

    public static void init(Set<Class<?>> classes, VaadinContext context) {
        List classesImplementingPageConfigurator;
        String message;
        ApplicationConfiguration config = ApplicationConfiguration.get(context);
        if (config.useV14Bootstrap()) {
            return;
        }
        boolean disregardOffendingAnnotations = config.getBooleanProperty("allow.appshell.annotations", false);
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        registry.reset();
        if (classes == null || classes.isEmpty()) {
            return;
        }
        ArrayList offendingAnnotations = new ArrayList();
        classes.stream().filter(clazz -> clazz != AppShellConfigurator.class).sorted((a, b) -> registry.isShell((Class<?>)a) ? -1 : (registry.isShell((Class<?>)b) ? 1 : 0)).forEach(clz -> {
            if (registry.isShell((Class<?>)clz)) {
                registry.setShell((Class<? extends AppShellConfigurator>)clz);
                VaadinAppShellInitializer.getLogger().debug("Using {} class for configuring `index.html` response", (Object)clz.getName());
            } else {
                String error = registry.validateClass((Class<?>)clz);
                if (error != null) {
                    offendingAnnotations.add(error);
                }
            }
        });
        if (!offendingAnnotations.isEmpty()) {
            if (disregardOffendingAnnotations) {
                boolean hasPwa = offendingAnnotations.stream().anyMatch(err -> err.matches(".*@PWA.*"));
                message = String.format(hasPwa ? "%n%nWe changed the way you configure PWAs, please see this link for more info:%nhttps://vaadin.com/docs/v15/flow/advanced/tutorial-modifying-the-bootstrap-page.html%n" : "%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n", String.join((CharSequence)"\n  ", offendingAnnotations));
                VaadinAppShellInitializer.getLogger().error(message);
            } else {
                String message2 = String.format("%n%nFound app shell configuration annotations in non `AppShellConfigurator` classes.%nPlease create a custom class implementing `AppShellConfigurator` and move the following annotations to it:%n  %s%n", String.join((CharSequence)"\n  ", offendingAnnotations));
                throw new InvalidApplicationConfigurationException(message2);
            }
        }
        if (!(classesImplementingPageConfigurator = classes.stream().filter(clz -> PageConfigurator.class.isAssignableFrom((Class<?>)clz)).filter(clazz -> clazz != PageConfigurator.class).map(Class::getName).collect(Collectors.toList())).isEmpty()) {
            message = String.join((CharSequence)"\n - ", classesImplementingPageConfigurator);
            if (registry.getShell() != null) {
                message = String.format("%n%nThe `PageConfigurator` interface is deprecated since Vaadin 15 and has no effect.%nPlease, configure the page in %s, and remove the `PageConfigurator` from: %n - %s%n", registry.getShell().getName(), message);
                throw new InvalidApplicationConfigurationException(message);
            }
            message = String.format("%n%nThe `PageConfigurator` interface is deprecated since Vaadin 15 and has no effect.%nPlease, create a class implementing `AppShellConfigurator`, and remove `PageConfigurator` from: %n  - %s%n", message);
            VaadinAppShellInitializer.getLogger().error(message);
        }
    }

    public static List<Class<? extends Annotation>> getValidAnnotations() {
        return Arrays.stream(VaadinAppShellInitializer.getHandledTypes()).filter(Class::isAnnotation).map(clz -> clz).collect(Collectors.toList());
    }

    public static List<Class<?>> getValidSupers() {
        return Arrays.stream(VaadinAppShellInitializer.getHandledTypes()).filter(clz -> !clz.isAnnotation()).collect(Collectors.toList());
    }

    private static Class<?>[] getHandledTypes() {
        HandlesTypes annotation = VaadinAppShellInitializer.class.getAnnotation(HandlesTypes.class);
        assert (annotation != null);
        return annotation.value();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinAppShellInitializer.class);
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

