/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.auth;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.function.Function;

public class EndpointAccessChecker {
    public static final String ACCESS_DENIED_MSG = "Access denied";
    public static final String ACCESS_DENIED_MSG_DEV_MODE = "Access denied to Vaadin endpoint; to enable endpoint access use one of the following annotations: @AnonymousAllowed, @PermitAll, @RolesAllowed";
    private final AccessAnnotationChecker accessAnnotationChecker;

    public EndpointAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
    }

    public String check(Method method, HttpServletRequest request) {
        return this.check(method, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
    }

    public String check(Class<?> clazz, HttpServletRequest request) {
        return this.check(clazz, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
    }

    public String check(Method method, Principal principal, Function<String, Boolean> rolesChecker) {
        if (this.accessAnnotationChecker.hasAccess(method, principal, rolesChecker)) {
            return null;
        }
        if (this.isDevMode()) {
            return ACCESS_DENIED_MSG_DEV_MODE;
        }
        return ACCESS_DENIED_MSG;
    }

    public String check(Class<?> clazz, Principal principal, Function<String, Boolean> rolesChecker) {
        if (this.accessAnnotationChecker.hasAccess(clazz, principal, rolesChecker)) {
            return null;
        }
        if (this.isDevMode()) {
            return ACCESS_DENIED_MSG_DEV_MODE;
        }
        return ACCESS_DENIED_MSG;
    }

    private boolean isDevMode() {
        VaadinService vaadinService = VaadinService.getCurrent();
        return vaadinService != null && !vaadinService.getDeploymentConfiguration().isProductionMode();
    }

    public AccessAnnotationChecker getAccessAnnotationChecker() {
        return this.accessAnnotationChecker;
    }
}

