/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route;

import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.hilla.route.ServerAndClientViewsProvider;
import java.io.IOException;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteUnifyingIndexHtmlRequestListener
implements IndexHtmlRequestListener {
    protected static final String SCRIPT_STRING = "window.Vaadin = window.Vaadin ?? {};\nwindow.Vaadin.views = %s;";
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteUnifyingIndexHtmlRequestListener.class);
    private ServerAndClientViewsProvider serverAndClientViewsProvider;

    public RouteUnifyingIndexHtmlRequestListener(ServerAndClientViewsProvider serverAndClientViewsProvider) {
        this.serverAndClientViewsProvider = serverAndClientViewsProvider;
    }

    public void modifyIndexHtmlResponse(IndexHtmlResponse response) {
        try {
            String script = SCRIPT_STRING.formatted(this.serverAndClientViewsProvider.createFileRoutesJson(response.getVaadinRequest()));
            response.getDocument().head().appendElement("script").appendChild((Node)new DataNode(script));
        }
        catch (IOException e) {
            LOGGER.error("Failure while to write client and server routes to index html response", (Throwable)e);
        }
    }
}

