/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.core.event;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.core.event.InvalidEventTypeException;
import com.vaadin.hilla.signals.core.event.MissingFieldException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class StateEvent<T> {
    static ObjectMapper MAPPER;
    private final String id;
    private final EventType eventType;
    private final T value;
    private final T expected;
    private Boolean accepted;
    private String validationError;

    public StateEvent(String id, EventType eventType, T value, T expected) {
        this.id = id;
        this.eventType = eventType;
        this.value = value;
        this.expected = expected;
    }

    public StateEvent(String id, EventType eventType, T value) {
        this(id, eventType, value, null);
    }

    public StateEvent(ObjectNode json, Class<T> valueType) {
        this.id = StateEvent.extractId((JsonNode)json);
        this.eventType = StateEvent.extractEventType((JsonNode)json);
        this.value = StateEvent.convertValue(StateEvent.extractValue((JsonNode)json, true), valueType);
        JsonNode expected = json.get("expected");
        this.expected = StateEvent.convertValue(expected, valueType);
    }

    public static void setMapper(ObjectMapper mapper) {
        MAPPER = mapper;
    }

    public static <X> X convertValue(JsonNode rawValue, Class<X> valueType) {
        if (rawValue == null) {
            return null;
        }
        return (X)MAPPER.convertValue((Object)rawValue, valueType);
    }

    public static String extractId(JsonNode json) {
        JsonNode id = json.get("id");
        if (id == null) {
            throw new MissingFieldException("id");
        }
        return id.asText();
    }

    public static JsonNode extractValue(JsonNode json, boolean required) {
        JsonNode value = json.get("value");
        if (value == null) {
            if (required) {
                throw new MissingFieldException("value");
            }
            return null;
        }
        return value;
    }

    public static JsonNode extractExpected(JsonNode json, boolean required) {
        JsonNode expected = json.get("expected");
        if (expected == null) {
            if (required) {
                throw new MissingFieldException("expected");
            }
            return null;
        }
        return expected;
    }

    public static String extractRawEventType(JsonNode json) {
        JsonNode rawType = json.get("type");
        if (rawType == null) {
            String message = String.format("Missing event type. Type is required, and should be one of: %s", Arrays.toString((Object[])EventType.values()));
            throw new MissingFieldException(message);
        }
        return rawType.asText();
    }

    public static EventType extractEventType(JsonNode json) {
        String rawType = StateEvent.extractRawEventType(json);
        try {
            return EventType.of(rawType);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Invalid event type %s. Type should be one of: %s", rawType, Arrays.toString((Object[])EventType.values()));
            throw new InvalidEventTypeException(message, e);
        }
    }

    public static boolean isSetEvent(ObjectNode event) {
        String rawEventType = StateEvent.extractRawEventType((JsonNode)event);
        if (rawEventType == null) {
            throw new MissingFieldException("type");
        }
        EventType eventType = EventType.find(rawEventType).orElseThrow(() -> new InvalidEventTypeException(rawEventType));
        return eventType == EventType.SET;
    }

    public static boolean isReplaceEvent(ObjectNode event) {
        String rawEventType = StateEvent.extractRawEventType((JsonNode)event);
        if (rawEventType == null) {
            throw new MissingFieldException("type");
        }
        EventType eventType = EventType.find(rawEventType).orElseThrow(() -> new InvalidEventTypeException(rawEventType));
        return eventType == EventType.REPLACE;
    }

    public ObjectNode toJson() {
        ObjectNode json = MAPPER.createObjectNode();
        json.put("id", this.id);
        json.put("type", this.eventType.name().toLowerCase());
        json.set("value", StateEvent.valueAsJsonNode(this.getValue()));
        if (this.getExpected() != null) {
            json.set("expected", StateEvent.valueAsJsonNode(this.getExpected()));
        }
        if (this.accepted != null) {
            json.put("accepted", this.accepted);
        }
        if (this.validationError != null) {
            json.put("validationError", this.validationError);
        }
        return json;
    }

    public static boolean isAccepted(ObjectNode event) {
        return event.has("accepted") && event.get("accepted").asBoolean();
    }

    public static boolean isRejected(ObjectNode event) {
        return event.has("accepted") && !event.get("accepted").asBoolean() && event.has("validationError") && !event.get("validationError").asText().isBlank();
    }

    public static String extractValidationError(ObjectNode event) {
        if (!StateEvent.isRejected(event)) {
            throw new IllegalStateException("The event is not rejected, so it does not have a validation error");
        }
        return event.get("validationError").asText();
    }

    public static void clearValidationError(ObjectNode event) {
        if (!StateEvent.isRejected(event)) {
            throw new IllegalStateException("The event is not rejected, so it does not have a validation error");
        }
        event.remove("validationError");
    }

    private static JsonNode valueAsJsonNode(Object value) {
        return MAPPER.valueToTree(value);
    }

    public String getId() {
        return this.id;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public T getValue() {
        return this.value;
    }

    public T getExpected() {
        return this.expected;
    }

    public Boolean getAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateEvent)) {
            return false;
        }
        StateEvent that = (StateEvent)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String getValidationError() {
        return this.validationError;
    }

    public void setValidationError(String validationError) {
        this.validationError = validationError;
    }

    public void clearValidationError() {
        this.validationError = null;
    }

    public static enum EventType {
        SNAPSHOT,
        SET,
        REPLACE,
        INCREMENT;


        public static EventType of(String type) {
            return EventType.valueOf(type.toUpperCase());
        }

        public static Optional<EventType> find(String type) {
            return Arrays.stream(EventType.values()).filter(e -> e.name().equalsIgnoreCase(type)).findFirst();
        }
    }

    public static final class Field {
        public static final String ID = "id";
        public static final String TYPE = "type";
        public static final String VALUE = "value";
        public static final String EXPECTED = "expected";
        public static final String ACCEPTED = "accepted";
        public static final String VALIDATION_ERROR = "validationError";
    }
}

