/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.event.ListStateEvent;
import com.vaadin.hilla.signals.core.registry.SecureSignalsRegistry;
import jakarta.annotation.Nullable;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@AnonymousAllowed
@Component
public class SignalsHandler {
    private static final String FEATURE_FLAG_ERROR_MESSAGE = "%n\n***********************************************************************************************************************\n*  The Hilla Fullstack Signals API is currently considered experimental and may change in the future.                 *\n*  To use it you need to explicitly enable it in Copilot, or by adding com.vaadin.experimental.fullstackSignals=true  *\n*    to src/main/resources/vaadin-featureflags.properties.                                                            *\n***********************************************************************************************************************\n%n".stripIndent();
    private final SecureSignalsRegistry registry;

    public SignalsHandler(@Nullable SecureSignalsRegistry registry) {
        this.registry = registry;
    }

    public Flux<ObjectNode> subscribe(String providerEndpoint, String providerMethod, String clientSignalId, ObjectNode body, @Nullable String parentClientSignalId) {
        if (this.registry == null) {
            throw new IllegalStateException(String.format(FEATURE_FLAG_ERROR_MESSAGE, new Object[0]));
        }
        try {
            if (parentClientSignalId != null) {
                return this.subscribe(parentClientSignalId, clientSignalId);
            }
            Signal<?> signal = this.registry.get(clientSignalId);
            if (signal != null) {
                return signal.subscribe().doFinally(event -> this.registry.unsubscribe(clientSignalId));
            }
            this.registry.register(clientSignalId, providerEndpoint, providerMethod, body);
            return this.registry.get(clientSignalId).subscribe().doFinally(event -> this.registry.unsubscribe(clientSignalId));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private Flux<ObjectNode> subscribe(String parentClientSignalId, String clientSignalId) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException {
        Signal<?> parentSignal = this.registry.get(parentClientSignalId);
        if (parentSignal == null) {
            throw new IllegalStateException(String.format("Parent Signal not found for parent client signal id: %s", parentClientSignalId));
        }
        return parentSignal.subscribe(clientSignalId).doFinally(event -> this.registry.unsubscribe(clientSignalId));
    }

    public void update(String clientSignalId, ObjectNode event) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException {
        if (this.registry == null) {
            throw new IllegalStateException(String.format(FEATURE_FLAG_ERROR_MESSAGE, new Object[0]));
        }
        String parentSignalId = ListStateEvent.extractParentSignalId((JsonNode)event);
        if (parentSignalId != null) {
            if (this.registry.get(parentSignalId) == null) {
                throw new IllegalStateException(String.format("Parent Signal not found for signal id: %s", parentSignalId));
            }
            this.registry.get(parentSignalId).submit(event);
        } else {
            if (this.registry.get(clientSignalId) == null) {
                throw new IllegalStateException(String.format("Signal not found for client signal: %s", clientSignalId));
            }
            this.registry.get(clientSignalId).submit(event);
        }
    }
}

