/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class VaadinComIntegration {
    private static final String BASE_URL = "https://vaadin.com/pro/validate-license";
    private static final String MANUAL_PRO_KEY_URL = "https://vaadin.com/pro/validate-license";

    ProKey openBrowserAndWaitForKey(Product product) {
        return this.openBrowserAndWaitForKey(product, LicenseChecker.systemBrowserUrlHandler);
    }

    ProKey openBrowserAndWaitForKey(Product product, Consumer<String> noKeyUrlHandler) {
        String uniqueId = UUID.randomUUID().toString();
        String loginUrl = this.constructUrl(uniqueId, product);
        noKeyUrlHandler.accept(loginUrl);
        return this.listenForProKey("https://vaadin.com/pro/validate-license/connect/" + uniqueId);
    }

    String constructUrl(String uniqueId, Product product) {
        return "https://vaadin.com/pro/validate-license?connect=" + uniqueId + "&productName=" + product.getName() + "&productVersion=" + product.getVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ProKey listenForProKey(String location) {
        try {
            Instant timeout = Instant.now().plusSeconds(60L);
            URL url = new URL(location);
            while (Instant.now().isBefore(timeout)) {
                VaadinComIntegration.getLogger().debug("Polling server for pro key");
                try (InputStream in = url.openStream();){
                    String data = Util.toString(in);
                    ProKey proKey = ProKey.fromJson(data);
                    return proKey;
                }
                catch (FileNotFoundException e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException throwable) {}
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new LicenseException("Error retreiving your subscription key from the server. Please try again or download the key manually from https://vaadin.com/pro/validate-license. If you need to work offline then " + OfflineKeyValidator.getOfflineKeyLinkMessage(MachineId.get()), e);
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

