/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.charts.Chart;
import com.vaadin.flow.component.charts.events.HasAxis;
import com.vaadin.flow.component.charts.model.YAxis;

@DomEvent(value="yaxes-extremes-set")
public class YAxesExtremesSetEvent
extends ComponentEvent<Chart>
implements HasAxis<YAxis> {
    private double minimum;
    private double maximum;
    private int axisIndex;

    public YAxesExtremesSetEvent(Chart source, boolean fromClient, @EventData(value="event.detail.originalEvent.min") double min, @EventData(value="event.detail.originalEvent.max") double max, @EventData(value="event.detail.axis.userOptions.axisIndex") int axisIndex) {
        super((Component)source, fromClient);
        this.minimum = min;
        this.maximum = max;
        this.axisIndex = axisIndex;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public int getAxisIndex() {
        return this.axisIndex;
    }

    @Override
    public YAxis getAxis() {
        return ((Chart)this.getSource()).getConfiguration().getyAxis(this.axisIndex);
    }
}

