/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.serializers.AxisListSerializer;
import com.vaadin.flow.component.charts.model.serializers.ChartEnumSerializer;
import com.vaadin.flow.component.charts.model.serializers.ChartOptionsBeanSerializerModifier;
import com.vaadin.flow.component.charts.model.serializers.DateSerializer;
import com.vaadin.flow.component.charts.model.serializers.DefaultBeanSerializerModifier;
import com.vaadin.flow.component.charts.model.serializers.GradientColorStopsSerializer;
import com.vaadin.flow.component.charts.model.serializers.InstantSerializer;
import com.vaadin.flow.component.charts.model.serializers.PaneListSerializer;
import com.vaadin.flow.component.charts.model.serializers.SolidColorSerializer;
import com.vaadin.flow.component.charts.model.serializers.StopSerializer;
import com.vaadin.flow.component.charts.model.serializers.TimeUnitMultiplesSerializer;
import java.io.Serializable;

public class ChartSerialization
implements Serializable {
    private static ObjectWriter jsonWriter;
    static final ObjectWriter jsonWriterChartOptions;

    private ChartSerialization() {
    }

    public static ObjectMapper createObjectMapper() {
        return ChartSerialization.createObjectMapper(new DefaultBeanSerializerModifier());
    }

    public static ObjectMapper createObjectMapper(BeanSerializerModifier modifier) {
        ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule(ChartEnumSerializer.getModule()).registerModule(StopSerializer.getModule()).registerModule(TimeUnitMultiplesSerializer.getModule()).registerModule(SolidColorSerializer.getModule()).registerModule(GradientColorStopsSerializer.getModule()).registerModule(AxisListSerializer.getModule()).registerModule(PaneListSerializer.getModule()).registerModule(DateSerializer.getModule()).registerModule(InstantSerializer.getModule());
        return mapper.setSerializerFactory(mapper.getSerializerFactory().withSerializerModifier(modifier));
    }

    public static void setObjectMapperInstance(ObjectWriter newObjectWriter) {
        jsonWriter = newObjectWriter;
    }

    public static String toJSON(AbstractConfigurationObject object) {
        try {
            return jsonWriter.writeValueAsString((Object)object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new RuntimeException("Error while serializing " + object.getClass().getSimpleName(), e);
        }
    }

    static {
        ObjectMapper defaultMapper = ChartSerialization.createObjectMapper();
        jsonWriterChartOptions = defaultMapper.setSerializerFactory(defaultMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new ChartOptionsBeanSerializerModifier())).writer();
        jsonWriter = ChartSerialization.createObjectMapper().writer();
    }
}

