/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.combobox;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.combobox.ComboBoxBase;
import com.vaadin.flow.component.combobox.MultiSelectComboBoxI18n;
import com.vaadin.flow.component.combobox.MultiSelectComboBoxSelectionModel;
import com.vaadin.flow.component.combobox.MultiSelectComboBoxVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.IdentifierProviderChangeEvent;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Tag(value="vaadin-multi-select-combo-box")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.0"), @NpmPackage(value="@vaadin/multi-select-combo-box", version="24.1.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/multi-select-combo-box/src/vaadin-multi-select-combo-box.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./comboBoxConnector.js")})
public class MultiSelectComboBox<TItem>
extends ComboBoxBase<MultiSelectComboBox<TItem>, TItem, Set<TItem>>
implements MultiSelect<MultiSelectComboBox<TItem>, TItem>,
HasThemeVariant<MultiSelectComboBoxVariant> {
    private final MultiSelectComboBoxSelectionModel<TItem> selectionModel = new MultiSelectComboBoxSelectionModel((SerializableFunction & Serializable)item -> this.getDataProvider().getId(item));
    private MultiSelectComboBoxI18n i18n;

    public MultiSelectComboBox() {
        this(50);
    }

    public MultiSelectComboBox(int pageSize) {
        super("selectedItems", new LinkedHashSet(), JsonArray.class, MultiSelectComboBox::presentationToModel, MultiSelectComboBox::modelToPresentation);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.selectionModel.setSelectedItems((Set)e.getValue());
            }
        });
        ComponentEventListener & Serializable listener = (ComponentEventListener & Serializable)e -> this.selectionModel.setIdentityProvider((SerializableFunction)e.getIdentifierProvider());
        ComponentUtil.addListener((Component)this, IdentifierProviderChangeEvent.class, (ComponentEventListener)listener);
        this.setPageSize(pageSize);
        this.setItems(new DataCommunicator.EmptyDataProvider());
    }

    public MultiSelectComboBox(String label) {
        this();
        this.setLabel(label);
    }

    public MultiSelectComboBox(String label, Collection<TItem> items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    @SafeVarargs
    public MultiSelectComboBox(String label, TItem ... items) {
        this();
        this.setLabel(label);
        this.setItems(items);
    }

    public MultiSelectComboBox(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<MultiSelectComboBox<TItem>, Set<TItem>>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public MultiSelectComboBox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<MultiSelectComboBox<TItem>, Set<TItem>>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    @SafeVarargs
    public MultiSelectComboBox(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<MultiSelectComboBox<TItem>, Set<TItem>>> listener, TItem ... items) {
        this(label, listener);
        this.setItems(items);
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.updateI18n();
        }
    }

    private static <T> Set<T> presentationToModel(MultiSelectComboBox<T> multiSelectComboBox, JsonArray presentation) {
        DataKeyMapper keyMapper = multiSelectComboBox.getKeyMapper();
        if (presentation == null || keyMapper == null) {
            return (Set)multiSelectComboBox.getEmptyValue();
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (int i = 0; i < presentation.length(); ++i) {
            String key = presentation.getObject(i).getString("key");
            set.add(keyMapper.get(key));
        }
        return set;
    }

    private static <T> JsonArray modelToPresentation(MultiSelectComboBox<T> multiSelectComboBox, Set<T> model) {
        JsonArray array = Json.createArray();
        if (model == null || model.isEmpty()) {
            return array;
        }
        model.stream().map(multiSelectComboBox::generateJson).forEach(jsonObject -> array.set(array.length(), (JsonValue)jsonObject));
        return array;
    }

    private JsonObject generateJson(TItem item) {
        JsonObject jsonObject = Json.createObject();
        jsonObject.put("key", this.getKeyMapper().key(item));
        this.getDataGenerator().generateData(item, jsonObject);
        return jsonObject;
    }

    public Set<TItem> getValue() {
        return Collections.unmodifiableSet((Set)super.getValue());
    }

    @Override
    public void setValue(Set<TItem> value) {
        boolean hasValueChanged;
        if (value == null) {
            value = Collections.emptySet();
        }
        if (hasValueChanged = this.selectionModel.setSelectedItems(value)) {
            super.setValue(value);
        }
    }

    @Override
    @SafeVarargs
    public final void setValue(TItem ... items) {
        LinkedHashSet<TItem> value = new LinkedHashSet<TItem>(List.of(items));
        this.setValue((Set<TItem>)value);
    }

    @Override
    public void setValue(Collection<TItem> items) {
        LinkedHashSet<TItem> value = new LinkedHashSet<TItem>(items);
        this.setValue((Set<TItem>)value);
    }

    @Override
    protected void refreshValue() {
        Object value = this.getValue();
        if (value == null || value.isEmpty()) {
            return;
        }
        JsonArray selectedItems = MultiSelectComboBox.modelToPresentation(this, value);
        this.getElement().setPropertyJson("selectedItems", (JsonValue)selectedItems);
    }

    @Override
    public boolean isSelected(TItem item) {
        Objects.requireNonNull(item, "Null can not be selected");
        return this.selectionModel.isSelected(item);
    }

    public Set<TItem> getSelectedItems() {
        return Collections.unmodifiableSet(this.selectionModel.getSelectedItems());
    }

    public Registration addSelectionListener(MultiSelectionListener<MultiSelectComboBox<TItem>, TItem> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }

    public void updateSelection(Set<TItem> addedItems, Set<TItem> removedItems) {
        boolean hasValueChanged = this.selectionModel.updateSelection(addedItems, removedItems);
        if (hasValueChanged) {
            super.setValue(this.selectionModel.getSelectedItems());
        }
    }

    public MultiSelectComboBoxI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(MultiSelectComboBoxI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.updateI18n();
    }

    private void updateI18n() {
        JsonObject i18nJson = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        this.removeNullValuesFromJsonObject(i18nJson);
        this.getElement().executeJs("this.i18n = Object.assign({}, this.i18n, $0);", new Serializable[]{i18nJson});
    }

    private void removeNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }
}

