/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.contextmenu.ContextMenuBase;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

@Tag(value="vaadin-context-menu-item")
@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.5.3")
@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js")
public abstract class MenuItemBase<C extends ContextMenuBase<C, I, S>, I extends MenuItemBase<C, I, S>, S extends SubMenuBase<C, I, S>>
extends Component
implements HasAriaLabel,
HasComponents,
HasEnabled,
HasText {
    private static final String PRIVATE_THEME_ATTRIBUTE = "__theme";
    private final C contextMenu;
    private S subMenu;
    private boolean checkable = false;
    private Set<String> themeNames = new LinkedHashSet<String>();

    public MenuItemBase(C contextMenu) {
        this.contextMenu = contextMenu;
        this.getElement().addEventListener("click", (DomEventListener & Serializable)e -> {
            if (this.checkable) {
                this.setChecked(!this.isChecked());
            }
        });
    }

    public C getContextMenu() {
        return this.contextMenu;
    }

    public S getSubMenu() {
        if (this.subMenu == null) {
            this.subMenu = this.createSubMenu();
        }
        return this.subMenu;
    }

    public boolean isParentItem() {
        return ((SubMenuBase)this.getSubMenu()).getChildren().findAny().isPresent();
    }

    public void setCheckable(boolean checkable) {
        if (checkable && this.isParentItem()) {
            throw new IllegalStateException("A checkable item cannot have a sub menu");
        }
        this.checkable = checkable;
        if (!checkable) {
            this.setChecked(false);
        }
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setChecked(boolean checked) {
        if (this.isChecked() == checked) {
            return;
        }
        if (!this.checkable && checked) {
            throw new IllegalStateException("Trying to set a non-checkable menu item checked. Use setCheckable() to make the item checkable first.");
        }
        this.getElement().setProperty("_checked", checked);
        this.executeJsWhenAttached("window.Vaadin.Flow.contextMenuConnector.setChecked($0, $1)", new Serializable[]{this.getElement(), Boolean.valueOf(checked)});
    }

    public boolean isChecked() {
        return this.getElement().getProperty("_checked", false);
    }

    public void setKeepOpen(boolean keepOpen) {
        if (keepOpen && this.isParentItem()) {
            throw new IllegalStateException("A keepOpen item cannot have a sub menu");
        }
        this.getElement().setProperty("_keepOpen", keepOpen);
        this.executeJsWhenAttached("window.Vaadin.Flow.contextMenuConnector.setKeepOpen($0, $1)", new Serializable[]{this.getElement(), Boolean.valueOf(keepOpen)});
    }

    public boolean isKeepOpen() {
        return this.getElement().getProperty("_keepOpen", false);
    }

    public void addThemeNames(String ... themeNames) {
        this.themeNames.addAll(Arrays.asList(themeNames));
        this.setThemeName();
    }

    public void removeThemeNames(String ... themeNames) {
        this.themeNames.removeAll(Arrays.asList(themeNames));
        this.setThemeName();
    }

    public boolean hasThemeName(String themeName) {
        return this.themeNames.contains(themeName);
    }

    private void setThemeName() {
        String themeName = this.themeNames.stream().collect(Collectors.joining(" "));
        if (themeName != null) {
            this.getElement().setProperty(PRIVATE_THEME_ATTRIBUTE, themeName);
        } else {
            this.getElement().removeProperty(PRIVATE_THEME_ATTRIBUTE);
        }
        this.executeJsWhenAttached("window.Vaadin.Flow.contextMenuConnector.setTheme($0, $1)", new Serializable[]{this.getElement(), themeName});
    }

    protected abstract S createSubMenu();

    protected void executeJsWhenAttached(String expression, Serializable ... parameters) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJs(expression, parameters)));
    }
}

