/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.OpenInCurrentIde;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdeIntegration {
    private ApplicationConfiguration configuration;

    public IdeIntegration(ApplicationConfiguration configuration) {
        this.configuration = configuration;
        if (configuration.isProductionMode()) {
            IdeIntegration.getLogger().error(this.getClass().getSimpleName() + " should never be created in production mode");
        }
    }

    public void showComponentCreateInIde(Component component) {
        UsageStatistics.markAsUsed((String)"flow/showComponentCreateInIde", null);
        this.internalShowInIde(component, ComponentTracker.findCreate((Component)component));
    }

    public void showComponentAttachInIde(Component component) {
        UsageStatistics.markAsUsed((String)"flow/showComponentAttachInIde", null);
        this.internalShowInIde(component, ComponentTracker.findAttach((Component)component));
    }

    private void internalShowInIde(Component component, ComponentTracker.Location location) {
        if (location == null) {
            IdeIntegration.getLogger().error("Unable to find the location where the component " + component.getClass().getName() + " was created");
            return;
        }
        File javaFile = location.findJavaFile((AbstractConfiguration)this.configuration);
        if (javaFile != null && !javaFile.exists()) {
            IdeIntegration.getLogger().error("Unable to find file in " + javaFile);
            return;
        }
        if (javaFile != null && OpenInCurrentIde.openFile(javaFile, location.lineNumber())) {
            return;
        }
        System.out.println(this.toStackTraceElement(location));
    }

    private StackTraceElement toStackTraceElement(ComponentTracker.Location location) {
        return new StackTraceElement("", "", "", location.className(), location.methodName(), location.filename(), location.lineNumber());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IdeIntegration.class);
    }
}

