/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.dom.Element;

interface ColumnBase<T extends ColumnBase<T>>
extends HasElement {
    default public T setResizable(boolean resizable) {
        this.getElement().setProperty("resizable", resizable);
        return (T)this;
    }

    @Synchronize(value={"resizable-changed"})
    default public boolean isResizable() {
        return this.getElement().getProperty("resizable", false);
    }

    default public T setFrozen(boolean frozen) {
        this.getElement().setProperty("frozen", frozen);
        return (T)this;
    }

    @Synchronize(value={"frozen-changed"})
    default public boolean isFrozen() {
        return this.getElement().getProperty("frozen", false);
    }

    default public T setFrozenToEnd(boolean frozenToEnd) {
        this.getElement().setProperty("frozenToEnd", frozenToEnd);
        return (T)this;
    }

    @Synchronize(value={"frozen-to-end-changed"})
    default public boolean isFrozenToEnd() {
        return this.getElement().getProperty("frozenToEnd", false);
    }

    default public T setTextAlign(ColumnTextAlign textAlign) {
        this.getElement().setProperty("textAlign", textAlign == null ? null : textAlign.getPropertyValue());
        if (this.getElement().getParent() != null) {
            this.getElement().getParent().getComponent().filter(parent -> parent instanceof AbstractColumn && parent.getChildren().count() == 1L).map(AbstractColumn.class::cast).ifPresent(parent -> parent.setTextAlign(textAlign));
        }
        return (T)this;
    }

    @Synchronize(value={"text-align-changed"})
    default public ColumnTextAlign getTextAlign() {
        return ColumnTextAlign.fromPropertyValue(this.getElement().getProperty("textAlign"));
    }

    public Element getElement();
}

