/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid.editor;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.grid.editor.EditorCancelEvent;
import com.vaadin.flow.component.grid.editor.EditorCancelListener;
import com.vaadin.flow.component.grid.editor.EditorCloseEvent;
import com.vaadin.flow.component.grid.editor.EditorCloseListener;
import com.vaadin.flow.component.grid.editor.EditorOpenEvent;
import com.vaadin.flow.component.grid.editor.EditorOpenListener;
import com.vaadin.flow.component.grid.editor.EditorSaveEvent;
import com.vaadin.flow.component.grid.editor.EditorSaveListener;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class EditorImpl<T>
extends Grid.AbstractGridExtension<T>
implements Editor<T> {
    private static final String EDITING = "_editing";
    private final Map<Class<?>, List<?>> listeners = new HashMap();
    private StateTree.ExecutionRegistration editItemRequestRegistration;
    private Binder<T> binder;
    private T edited;
    private boolean isBuffered;

    public EditorImpl(Grid<T> grid, PropertySet<T> propertySet) {
        super(grid);
        if (propertySet != null) {
            this.binder = Binder.withPropertySet(propertySet);
        }
        this.getGrid().addItemClickListener(this::handleItemClick);
    }

    @Override
    public Editor<T> setBinder(Binder<T> binder) {
        Objects.requireNonNull(binder, "Binder can't edit null");
        this.binder = binder;
        return this;
    }

    @Override
    public Binder<T> getBinder() {
        if (this.binder == null) {
            LoggerFactory.getLogger(EditorImpl.class).warn("The editor binder is null. You have to set it explicitly.");
        }
        return this.binder;
    }

    @Override
    public Editor<T> setBuffered(boolean buffered) {
        this.isBuffered = buffered;
        return this;
    }

    @Override
    public boolean isBuffered() {
        return this.isBuffered;
    }

    @Override
    public boolean isOpen() {
        return this.edited != null;
    }

    @Override
    public boolean save() {
        if (this.isOpen() && this.isBuffered()) {
            this.getBinder().validate();
            if (this.getBinder().writeBeanIfValid(this.edited)) {
                this.fireSaveEvent(new EditorSaveEvent<T>(this, this.edited));
                this.close();
                return true;
            }
        }
        return false;
    }

    @Override
    public void cancel() {
        this.fireCancelEvent(new EditorCancelEvent<T>(this, this.edited));
        this.close();
    }

    @Override
    public void closeEditor() {
        if (this.isOpen() && this.isBuffered()) {
            throw new UnsupportedOperationException("Buffered editor should be closed using save() or cancel()");
        }
        this.close();
    }

    @Override
    public void editItem(T item) {
        Objects.requireNonNull(item, "Editor can't edit null");
        T it = item;
        this.getGrid().getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> {
            if (this.editItemRequestRegistration != null) {
                this.editItemRequestRegistration.remove();
            }
            this.editItemRequestRegistration = ui.beforeClientResponse(this.getGrid(), (SerializableConsumer & Serializable)context -> {
                this.requestEditItem(it);
                this.editItemRequestRegistration = null;
            });
        });
    }

    private void requestEditItem(T item) {
        this.validate(item);
        this.close();
        this.edited = item;
        this.refresh(item);
        if (this.isBuffered()) {
            this.binder.readBean(item);
        } else {
            this.binder.setBean(item);
        }
        this.fireOpenEvent(new EditorOpenEvent<T>(this, this.edited));
    }

    @Override
    public void refresh() {
        if (!this.isOpen()) {
            return;
        }
        this.refresh(this.edited);
    }

    @Override
    public T getItem() {
        return this.edited;
    }

    @Override
    public Grid<T> getGrid() {
        return super.getGrid();
    }

    public void generateData(T item, JsonObject jsonObject) {
        if (item != null && item.equals(this.edited)) {
            jsonObject.put(EDITING, true);
        } else {
            jsonObject.remove(EDITING);
        }
    }

    private void close() {
        if (this.edited != null) {
            T oldEdited = this.edited;
            this.edited = null;
            this.refresh(oldEdited);
            this.fireCloseEvent(new EditorCloseEvent<T>(this, oldEdited));
        }
    }

    private void handleItemClick(ItemClickEvent<T> event) {
        DataProvider<T, ?> dataProvider = this.getGrid().getDataProvider();
        if (!this.isBuffered() && this.edited != null && !dataProvider.getId(this.edited).equals(dataProvider.getId(event.getItem()))) {
            this.close();
        }
    }

    private void validate(T item) {
        if (this.getBinder() == null) {
            throw new IllegalStateException("Editor doesn't have a binder. It's needed to be set explicitly. An example of setting the Binder: Binder<Person> binder = new Binder<>(Person.class); grid.setBinder(binder)");
        }
        if (this.isBuffered() && this.edited != null) {
            throw new IllegalStateException("Editing item " + item + " failed. Item editor is already editing item " + this.edited);
        }
    }

    @Override
    public Registration addSaveListener(EditorSaveListener<T> listener) {
        return this.addListener(EditorSaveListener.class, listener);
    }

    @Override
    public Registration addCancelListener(EditorCancelListener<T> listener) {
        return this.addListener(EditorCancelListener.class, listener);
    }

    @Override
    public Registration addOpenListener(EditorOpenListener<T> listener) {
        return this.addListener(EditorOpenListener.class, listener);
    }

    @Override
    public Registration addCloseListener(EditorCloseListener<T> listener) {
        return this.addListener(EditorCloseListener.class, listener);
    }

    private <L> Registration addListener(Class<L> listenerType, L listener) {
        List list = this.listeners.computeIfAbsent(listenerType, key -> Collections.synchronizedList(new ArrayList(1)));
        list.add(listener);
        return (Registration & Serializable)() -> list.remove(listener);
    }

    private void fireOpenEvent(EditorOpenEvent<T> event) {
        List<?> list = this.listeners.get(EditorOpenListener.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        new ArrayList(list).forEach(listener -> listener.onEditorOpen(event));
    }

    private void fireCancelEvent(EditorCancelEvent<T> event) {
        List<?> list = this.listeners.get(EditorCancelListener.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        new ArrayList(list).forEach(listener -> listener.onEditorCancel(event));
    }

    private void fireSaveEvent(EditorSaveEvent<T> event) {
        List<?> list = this.listeners.get(EditorSaveListener.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        new ArrayList(list).forEach(listener -> listener.onEditorSave(event));
    }

    private void fireCloseEvent(EditorCloseEvent<T> event) {
        List<?> list = this.listeners.get(EditorCloseListener.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        new ArrayList(list).forEach(listener -> listener.onEditorClose(event));
    }
}

