/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

package com.vaadin.event;

import java.util.EventObject;

import com.vaadin.server.ClientConnector;

/**
 * A base class for user interface events fired by connectors.
 *
 * @author Vaadin Ltd.
 * @since 7.0
 */
public abstract class ConnectorEvent extends EventObject {

    /**
     * Creates a new event fired by the given source.
     *
     * @param source
     *            the source connector
     */
    public ConnectorEvent(ClientConnector source) {
        super(source);
    }

    /**
     * Returns the connector that fired the event.
     *
     * @return the source connector
     */
    public ClientConnector getConnector() {
        return (ClientConnector) getSource();
    }
}
