/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import java.util.HashMap;
import java.util.Map;

import com.vaadin.server.Resource;

/**
 * Icon generator class for declarative support.
 * <p>
 * Provides a straightforward mapping between an item and its icon.
 *
 * @param <T>
 *            item type
 */
class DeclarativeIconGenerator<T> implements IconGenerator<T> {

    private IconGenerator<T> fallback;
    private Map<T, Resource> captions = new HashMap<>();

    public DeclarativeIconGenerator(IconGenerator<T> fallback) {
        this.fallback = fallback;
    }

    @Override
    public Resource apply(T item) {
        return captions.containsKey(item) ? captions.get(item)
                : fallback.apply(item);
    }

    /**
     * Sets an {@code icon} for the {@code item}.
     *
     * @param item
     *            a data item
     * @param icon
     *            an icon for the {@code item}
     */
    protected void setIcon(T item, Resource icon) {
        captions.put(item, icon);
    }

}
