/*
 * Copyright (C) 2000-2023 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.declarative.converters;

import java.util.TimeZone;

import com.vaadin.data.Converter;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.ui.declarative.DesignAttributeHandler;

/**
 * Utility class for {@link DesignAttributeHandler} that deals with converting
 * various TimeZones to string.
 *
 * @since 7.4
 * @author Vaadin Ltd
 */
public class DesignTimeZoneConverter implements Converter<String, TimeZone> {

    @Override
    public Result<TimeZone> convertToModel(String value, ValueContext context) {
        if (value == null || value.isEmpty()) {
            return Result.ok(null);
        }

        return Result.ok(TimeZone.getTimeZone(value));
    }

    @Override
    public String convertToPresentation(TimeZone value, ValueContext context) {
        if (value == null) {
            return "";
        } else {
            return value.getID();
        }
    }

}
