
// GENERATED FILE - DO NOT EDIT

package com.google.gwt.thirdparty.guava.common.net;

import com.google.gwt.thirdparty.guava.common.annotations.GwtCompatible;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;

import java.util.Set;

/**
 * A generated static class containing public members which provide domain
 * name patterns used in determining whether a given domain name is an
 * effective top-level domain (TLD).
 */
@GwtCompatible
class TldPatterns {
  private TldPatterns() {
    // Prevent instantiation.
  }

  /**
   * If a hostname is contained in this set, it is a TLD.
   */
  static final Set<String> EXACT = ImmutableSet.of(
      "ac",
      "com.ac",
      "edu.ac",
      "gov.ac",
      "net.ac",
      "mil.ac",
      "org.ac",
      "ad",
      "nom.ad",
      "ae",
      "co.ae",
      "net.ae",
      "org.ae",
      "sch.ae",
      "ac.ae",
      "gov.ae",
      "mil.ae",
      "aero",
      "accident-investigation.aero",
      "accident-prevention.aero",
      "aerobatic.aero",
      "aeroclub.aero",
      "aerodrome.aero",
      "agents.aero",
      "aircraft.aero",
      "airline.aero",
      "airport.aero",
      "air-surveillance.aero",
      "airtraffic.aero",
      "air-traffic-control.aero",
      "ambulance.aero",
      "amusement.aero",
      "association.aero",
      "author.aero",
      "ballooning.aero",
      "broker.aero",
      "caa.aero",
      "cargo.aero",
      "catering.aero",
      "certification.aero",
      "championship.aero",
      "charter.aero",
      "civilaviation.aero",
      "club.aero",
      "conference.aero",
      "consultant.aero",
      "consulting.aero",
      "control.aero",
      "council.aero",
      "crew.aero",
      "design.aero",
      "dgca.aero",
      "educator.aero",
      "emergency.aero",
      "engine.aero",
      "engineer.aero",
      "entertainment.aero",
      "equipment.aero",
      "exchange.aero",
      "express.aero",
      "federation.aero",
      "flight.aero",
      "freight.aero",
      "fuel.aero",
      "gliding.aero",
      "government.aero",
      "groundhandling.aero",
      "group.aero",
      "hanggliding.aero",
      "homebuilt.aero",
      "insurance.aero",
      "journal.aero",
      "journalist.aero",
      "leasing.aero",
      "logistics.aero",
      "magazine.aero",
      "maintenance.aero",
      "marketplace.aero",
      "media.aero",
      "microlight.aero",
      "modelling.aero",
      "navigation.aero",
      "parachuting.aero",
      "paragliding.aero",
      "passenger-association.aero",
      "pilot.aero",
      "press.aero",
      "production.aero",
      "recreation.aero",
      "repbody.aero",
      "res.aero",
      "research.aero",
      "rotorcraft.aero",
      "safety.aero",
      "scientist.aero",
      "services.aero",
      "show.aero",
      "skydiving.aero",
      "software.aero",
      "student.aero",
      "taxi.aero",
      "trader.aero",
      "trading.aero",
      "trainer.aero",
      "union.aero",
      "workinggroup.aero",
      "works.aero",
      "af",
      "gov.af",
      "com.af",
      "org.af",
      "net.af",
      "edu.af",
      "ag",
      "com.ag",
      "org.ag",
      "net.ag",
      "co.ag",
      "nom.ag",
      "ai",
      "off.ai",
      "com.ai",
      "net.ai",
      "org.ai",
      "al",
      "com.al",
      "edu.al",
      "gov.al",
      "mil.al",
      "net.al",
      "org.al",
      "am",
      "an",
      "com.an",
      "net.an",
      "org.an",
      "edu.an",
      "ao",
      "ed.ao",
      "gv.ao",
      "og.ao",
      "co.ao",
      "pb.ao",
      "it.ao",
      "aq",
      "e164.arpa",
      "in-addr.arpa",
      "ip6.arpa",
      "iris.arpa",
      "uri.arpa",
      "urn.arpa",
      "as",
      "gov.as",
      "asia",
      "at",
      "ac.at",
      "co.at",
      "gv.at",
      "or.at",
      "biz.at",
      "info.at",
      "priv.at",
      "act.edu.au",
      "nsw.edu.au",
      "nt.edu.au",
      "qld.edu.au",
      "sa.edu.au",
      "tas.edu.au",
      "vic.edu.au",
      "wa.edu.au",
      "act.gov.au",
      "nt.gov.au",
      "qld.gov.au",
      "sa.gov.au",
      "tas.gov.au",
      "vic.gov.au",
      "wa.gov.au",
      "act.au",
      "nsw.au",
      "nt.au",
      "qld.au",
      "sa.au",
      "tas.au",
      "vic.au",
      "wa.au",
      "aw",
      "com.aw",
      "ax",
      "az",
      "com.az",
      "net.az",
      "int.az",
      "gov.az",
      "org.az",
      "edu.az",
      "info.az",
      "pp.az",
      "mil.az",
      "name.az",
      "pro.az",
      "biz.az",
      "ba",
      "org.ba",
      "net.ba",
      "edu.ba",
      "gov.ba",
      "mil.ba",
      "unsa.ba",
      "unbi.ba",
      "co.ba",
      "com.ba",
      "rs.ba",
      "bb",
      "biz.bb",
      "com.bb",
      "edu.bb",
      "gov.bb",
      "info.bb",
      "net.bb",
      "org.bb",
      "store.bb",
      "be",
      "ac.be",
      "bf",
      "gov.bf",
      "bg",
      "a.bg",
      "b.bg",
      "c.bg",
      "d.bg",
      "e.bg",
      "f.bg",
      "g.bg",
      "h.bg",
      "i.bg",
      "j.bg",
      "k.bg",
      "l.bg",
      "m.bg",
      "n.bg",
      "o.bg",
      "p.bg",
      "q.bg",
      "r.bg",
      "s.bg",
      "t.bg",
      "u.bg",
      "v.bg",
      "w.bg",
      "x.bg",
      "y.bg",
      "z.bg",
      "0.bg",
      "1.bg",
      "2.bg",
      "3.bg",
      "4.bg",
      "5.bg",
      "6.bg",
      "7.bg",
      "8.bg",
      "9.bg",
      "bh",
      "com.bh",
      "edu.bh",
      "net.bh",
      "org.bh",
      "gov.bh",
      "bi",
      "co.bi",
      "com.bi",
      "edu.bi",
      "or.bi",
      "org.bi",
      "biz",
      "bj",
      "asso.bj",
      "barreau.bj",
      "gouv.bj",
      "bm",
      "com.bm",
      "edu.bm",
      "gov.bm",
      "net.bm",
      "org.bm",
      "bo",
      "com.bo",
      "edu.bo",
      "gov.bo",
      "gob.bo",
      "int.bo",
      "org.bo",
      "net.bo",
      "mil.bo",
      "tv.bo",
      "br",
      "adm.br",
      "adv.br",
      "agr.br",
      "am.br",
      "arq.br",
      "art.br",
      "ato.br",
      "b.br",
      "bio.br",
      "blog.br",
      "bmd.br",
      "can.br",
      "cim.br",
      "cng.br",
      "cnt.br",
      "com.br",
      "coop.br",
      "ecn.br",
      "edu.br",
      "emp.br",
      "eng.br",
      "esp.br",
      "etc.br",
      "eti.br",
      "far.br",
      "flog.br",
      "fm.br",
      "fnd.br",
      "fot.br",
      "fst.br",
      "g12.br",
      "ggf.br",
      "gov.br",
      "imb.br",
      "ind.br",
      "inf.br",
      "jor.br",
      "jus.br",
      "lel.br",
      "mat.br",
      "med.br",
      "mil.br",
      "mus.br",
      "net.br",
      "nom.br",
      "not.br",
      "ntr.br",
      "odo.br",
      "org.br",
      "ppg.br",
      "pro.br",
      "psc.br",
      "psi.br",
      "qsl.br",
      "radio.br",
      "rec.br",
      "slg.br",
      "srv.br",
      "taxi.br",
      "teo.br",
      "tmp.br",
      "trd.br",
      "tur.br",
      "tv.br",
      "vet.br",
      "vlog.br",
      "wiki.br",
      "zlg.br",
      "bs",
      "com.bs",
      "net.bs",
      "org.bs",
      "edu.bs",
      "gov.bs",
      "bt",
      "com.bt",
      "edu.bt",
      "gov.bt",
      "net.bt",
      "org.bt",
      "bw",
      "co.bw",
      "org.bw",
      "by",
      "gov.by",
      "mil.by",
      "com.by",
      "of.by",
      "bz",
      "com.bz",
      "net.bz",
      "org.bz",
      "edu.bz",
      "gov.bz",
      "ca",
      "ab.ca",
      "bc.ca",
      "mb.ca",
      "nb.ca",
      "nf.ca",
      "nl.ca",
      "ns.ca",
      "nt.ca",
      "nu.ca",
      "on.ca",
      "pe.ca",
      "qc.ca",
      "sk.ca",
      "yk.ca",
      "gc.ca",
      "cat",
      "cc",
      "cd",
      "gov.cd",
      "cf",
      "cg",
      "ch",
      "ci",
      "org.ci",
      "or.ci",
      "com.ci",
      "co.ci",
      "edu.ci",
      "ed.ci",
      "ac.ci",
      "net.ci",
      "go.ci",
      "asso.ci",
      "a\u00e9roport.ci",
      "xn--aroport-bya.ci",
      "int.ci",
      "presse.ci",
      "md.ci",
      "gouv.ci",
      "cl",
      "gov.cl",
      "gob.cl",
      "cm",
      "gov.cm",
      "cn",
      "ac.cn",
      "com.cn",
      "edu.cn",
      "gov.cn",
      "net.cn",
      "org.cn",
      "mil.cn",
      "\u516c\u53f8.cn",
      "xn--55qx5d.cn",
      "\u7f51\u7edc.cn",
      "xn--io0a7i.cn",
      "\u7db2\u7d61.cn",
      "xn--od0alg.cn",
      "ah.cn",
      "bj.cn",
      "cq.cn",
      "fj.cn",
      "gd.cn",
      "gs.cn",
      "gz.cn",
      "gx.cn",
      "ha.cn",
      "hb.cn",
      "he.cn",
      "hi.cn",
      "hl.cn",
      "hn.cn",
      "jl.cn",
      "js.cn",
      "jx.cn",
      "ln.cn",
      "nm.cn",
      "nx.cn",
      "qh.cn",
      "sc.cn",
      "sd.cn",
      "sh.cn",
      "sn.cn",
      "sx.cn",
      "tj.cn",
      "xj.cn",
      "xz.cn",
      "yn.cn",
      "zj.cn",
      "hk.cn",
      "mo.cn",
      "tw.cn",
      "co",
      "arts.co",
      "com.co",
      "edu.co",
      "firm.co",
      "gov.co",
      "info.co",
      "int.co",
      "mil.co",
      "net.co",
      "nom.co",
      "org.co",
      "rec.co",
      "web.co",
      "com",
      "ar.com",
      "br.com",
      "cn.com",
      "de.com",
      "eu.com",
      "gb.com",
      "hu.com",
      "jpn.com",
      "kr.com",
      "no.com",
      "qc.com",
      "ru.com",
      "sa.com",
      "se.com",
      "uk.com",
      "us.com",
      "uy.com",
      "za.com",
      "operaunite.com",
      "appspot.com",
      "coop",
      "cr",
      "ac.cr",
      "co.cr",
      "ed.cr",
      "fi.cr",
      "go.cr",
      "or.cr",
      "sa.cr",
      "cu",
      "com.cu",
      "edu.cu",
      "org.cu",
      "net.cu",
      "gov.cu",
      "inf.cu",
      "cv",
      "cx",
      "gov.cx",
      "cz",
      "de",
      "dj",
      "dk",
      "dm",
      "com.dm",
      "net.dm",
      "org.dm",
      "edu.dm",
      "gov.dm",
      "do",
      "art.do",
      "com.do",
      "edu.do",
      "gob.do",
      "gov.do",
      "mil.do",
      "net.do",
      "org.do",
      "sld.do",
      "web.do",
      "dz",
      "com.dz",
      "org.dz",
      "net.dz",
      "gov.dz",
      "edu.dz",
      "asso.dz",
      "pol.dz",
      "art.dz",
      "ec",
      "com.ec",
      "info.ec",
      "net.ec",
      "fin.ec",
      "k12.ec",
      "med.ec",
      "pro.ec",
      "org.ec",
      "edu.ec",
      "gov.ec",
      "gob.ec",
      "mil.ec",
      "edu",
      "ee",
      "edu.ee",
      "gov.ee",
      "riik.ee",
      "lib.ee",
      "med.ee",
      "com.ee",
      "pri.ee",
      "aip.ee",
      "org.ee",
      "fie.ee",
      "eg",
      "com.eg",
      "edu.eg",
      "eun.eg",
      "gov.eg",
      "mil.eg",
      "name.eg",
      "net.eg",
      "org.eg",
      "sci.eg",
      "es",
      "com.es",
      "nom.es",
      "org.es",
      "gob.es",
      "edu.es",
      "eu",
      "fi",
      "aland.fi",
      "iki.fi",
      "fm",
      "fo",
      "fr",
      "com.fr",
      "asso.fr",
      "nom.fr",
      "prd.fr",
      "presse.fr",
      "tm.fr",
      "aeroport.fr",
      "assedic.fr",
      "avocat.fr",
      "avoues.fr",
      "cci.fr",
      "chambagri.fr",
      "chirurgiens-dentistes.fr",
      "experts-comptables.fr",
      "geometre-expert.fr",
      "gouv.fr",
      "greta.fr",
      "huissier-justice.fr",
      "medecin.fr",
      "notaires.fr",
      "pharmacien.fr",
      "port.fr",
      "veterinaire.fr",
      "ga",
      "gd",
      "ge",
      "com.ge",
      "edu.ge",
      "gov.ge",
      "org.ge",
      "mil.ge",
      "net.ge",
      "pvt.ge",
      "gf",
      "gg",
      "co.gg",
      "org.gg",
      "net.gg",
      "sch.gg",
      "gov.gg",
      "gh",
      "com.gh",
      "edu.gh",
      "gov.gh",
      "org.gh",
      "mil.gh",
      "gi",
      "com.gi",
      "ltd.gi",
      "gov.gi",
      "mod.gi",
      "edu.gi",
      "org.gi",
      "gl",
      "gm",
      "ac.gn",
      "com.gn",
      "edu.gn",
      "gov.gn",
      "org.gn",
      "net.gn",
      "gov",
      "gp",
      "com.gp",
      "net.gp",
      "mobi.gp",
      "edu.gp",
      "org.gp",
      "asso.gp",
      "gq",
      "gr",
      "com.gr",
      "edu.gr",
      "net.gr",
      "org.gr",
      "gov.gr",
      "gs",
      "gw",
      "gy",
      "co.gy",
      "com.gy",
      "net.gy",
      "hk",
      "com.hk",
      "edu.hk",
      "gov.hk",
      "idv.hk",
      "net.hk",
      "org.hk",
      "\u516c\u53f8.hk",
      "xn--55qx5d.hk",
      "\u6559\u80b2.hk",
      "xn--wcvs22d.hk",
      "\u654e\u80b2.hk",
      "xn--lcvr32d.hk",
      "\u653f\u5e9c.hk",
      "xn--mxtq1m.hk",
      "\u500b\u4eba.hk",
      "xn--gmqw5a.hk",
      "\u4e2a\u4eba.hk",
      "xn--ciqpn.hk",
      "\u7b87\u4eba.hk",
      "xn--gmq050i.hk",
      "\u7db2\u7edc.hk",
      "xn--zf0avx.hk",
      "\u7f51\u7edc.hk",
      "xn--io0a7i.hk",
      "\u7ec4\u7e54.hk",
      "xn--mk0axi.hk",
      "\u7db2\u7d61.hk",
      "xn--od0alg.hk",
      "\u7f51\u7d61.hk",
      "xn--od0aq3b.hk",
      "\u7ec4\u7ec7.hk",
      "xn--tn0ag.hk",
      "\u7d44\u7e54.hk",
      "xn--uc0atv.hk",
      "\u7d44\u7ec7.hk",
      "xn--uc0ay4a.hk",
      "hm",
      "hn",
      "com.hn",
      "edu.hn",
      "org.hn",
      "net.hn",
      "mil.hn",
      "gob.hn",
      "hr",
      "iz.hr",
      "from.hr",
      "name.hr",
      "com.hr",
      "ht",
      "com.ht",
      "shop.ht",
      "firm.ht",
      "info.ht",
      "adult.ht",
      "net.ht",
      "pro.ht",
      "org.ht",
      "med.ht",
      "art.ht",
      "coop.ht",
      "pol.ht",
      "asso.ht",
      "edu.ht",
      "rel.ht",
      "gouv.ht",
      "perso.ht",
      "hu",
      "co.hu",
      "info.hu",
      "org.hu",
      "priv.hu",
      "sport.hu",
      "tm.hu",
      "2000.hu",
      "agrar.hu",
      "bolt.hu",
      "casino.hu",
      "city.hu",
      "erotica.hu",
      "erotika.hu",
      "film.hu",
      "forum.hu",
      "games.hu",
      "hotel.hu",
      "ingatlan.hu",
      "jogasz.hu",
      "konyvelo.hu",
      "lakas.hu",
      "media.hu",
      "news.hu",
      "reklam.hu",
      "sex.hu",
      "shop.hu",
      "suli.hu",
      "szex.hu",
      "tozsde.hu",
      "utazas.hu",
      "video.hu",
      "id",
      "ac.id",
      "co.id",
      "go.id",
      "mil.id",
      "net.id",
      "or.id",
      "sch.id",
      "web.id",
      "ie",
      "gov.ie",
      "im",
      "co.im",
      "ltd.co.im",
      "plc.co.im",
      "net.im",
      "gov.im",
      "org.im",
      "nic.im",
      "ac.im",
      "in",
      "co.in",
      "firm.in",
      "net.in",
      "org.in",
      "gen.in",
      "ind.in",
      "nic.in",
      "ac.in",
      "edu.in",
      "res.in",
      "gov.in",
      "mil.in",
      "info",
      "int",
      "eu.int",
      "io",
      "com.io",
      "iq",
      "gov.iq",
      "edu.iq",
      "mil.iq",
      "com.iq",
      "org.iq",
      "net.iq",
      "ir",
      "ac.ir",
      "co.ir",
      "gov.ir",
      "id.ir",
      "net.ir",
      "org.ir",
      "sch.ir",
      "\u0627\u06cc\u0631\u0627\u0646.ir",
      "xn--mgba3a4f16a.ir",
      "\u0627\u064a\u0631\u0627\u0646.ir",
      "xn--mgba3a4fra.ir",
      "is",
      "net.is",
      "com.is",
      "edu.is",
      "gov.is",
      "org.is",
      "int.is",
      "it",
      "gov.it",
      "edu.it",
      "agrigento.it",
      "ag.it",
      "alessandria.it",
      "al.it",
      "ancona.it",
      "an.it",
      "aosta.it",
      "aoste.it",
      "ao.it",
      "arezzo.it",
      "ar.it",
      "ascoli-piceno.it",
      "ascolipiceno.it",
      "ap.it",
      "asti.it",
      "at.it",
      "avellino.it",
      "av.it",
      "bari.it",
      "ba.it",
      "andria-barletta-trani.it",
      "andriabarlettatrani.it",
      "trani-barletta-andria.it",
      "tranibarlettaandria.it",
      "barletta-trani-andria.it",
      "barlettatraniandria.it",
      "andria-trani-barletta.it",
      "andriatranibarletta.it",
      "trani-andria-barletta.it",
      "traniandriabarletta.it",
      "bt.it",
      "belluno.it",
      "bl.it",
      "benevento.it",
      "bn.it",
      "bergamo.it",
      "bg.it",
      "biella.it",
      "bi.it",
      "bologna.it",
      "bo.it",
      "bolzano.it",
      "bozen.it",
      "balsan.it",
      "alto-adige.it",
      "altoadige.it",
      "suedtirol.it",
      "bz.it",
      "brescia.it",
      "bs.it",
      "brindisi.it",
      "br.it",
      "cagliari.it",
      "ca.it",
      "caltanissetta.it",
      "cl.it",
      "campobasso.it",
      "cb.it",
      "carboniaiglesias.it",
      "carbonia-iglesias.it",
      "iglesias-carbonia.it",
      "iglesiascarbonia.it",
      "ci.it",
      "caserta.it",
      "ce.it",
      "catania.it",
      "ct.it",
      "catanzaro.it",
      "cz.it",
      "chieti.it",
      "ch.it",
      "como.it",
      "co.it",
      "cosenza.it",
      "cs.it",
      "cremona.it",
      "cr.it",
      "crotone.it",
      "kr.it",
      "cuneo.it",
      "cn.it",
      "dell-ogliastra.it",
      "dellogliastra.it",
      "ogliastra.it",
      "og.it",
      "enna.it",
      "en.it",
      "ferrara.it",
      "fe.it",
      "fermo.it",
      "fm.it",
      "firenze.it",
      "florence.it",
      "fi.it",
      "foggia.it",
      "fg.it",
      "forli-cesena.it",
      "forlicesena.it",
      "cesena-forli.it",
      "cesenaforli.it",
      "fc.it",
      "frosinone.it",
      "fr.it",
      "genova.it",
      "genoa.it",
      "ge.it",
      "gorizia.it",
      "go.it",
      "grosseto.it",
      "gr.it",
      "imperia.it",
      "im.it",
      "isernia.it",
      "is.it",
      "laquila.it",
      "aquila.it",
      "aq.it",
      "la-spezia.it",
      "laspezia.it",
      "sp.it",
      "latina.it",
      "lt.it",
      "lecce.it",
      "le.it",
      "lecco.it",
      "lc.it",
      "livorno.it",
      "li.it",
      "lodi.it",
      "lo.it",
      "lucca.it",
      "lu.it",
      "macerata.it",
      "mc.it",
      "mantova.it",
      "mn.it",
      "massa-carrara.it",
      "massacarrara.it",
      "carrara-massa.it",
      "carraramassa.it",
      "ms.it",
      "matera.it",
      "mt.it",
      "medio-campidano.it",
      "mediocampidano.it",
      "campidano-medio.it",
      "campidanomedio.it",
      "vs.it",
      "messina.it",
      "me.it",
      "milano.it",
      "milan.it",
      "mi.it",
      "modena.it",
      "mo.it",
      "monza.it",
      "monza-brianza.it",
      "monzabrianza.it",
      "monzaebrianza.it",
      "monzaedellabrianza.it",
      "monza-e-della-brianza.it",
      "mb.it",
      "napoli.it",
      "naples.it",
      "na.it",
      "novara.it",
      "no.it",
      "nuoro.it",
      "nu.it",
      "oristano.it",
      "or.it",
      "padova.it",
      "padua.it",
      "pd.it",
      "palermo.it",
      "pa.it",
      "parma.it",
      "pr.it",
      "pavia.it",
      "pv.it",
      "perugia.it",
      "pg.it",
      "pescara.it",
      "pe.it",
      "pesaro-urbino.it",
      "pesarourbino.it",
      "urbino-pesaro.it",
      "urbinopesaro.it",
      "pu.it",
      "piacenza.it",
      "pc.it",
      "pisa.it",
      "pi.it",
      "pistoia.it",
      "pt.it",
      "pordenone.it",
      "pn.it",
      "potenza.it",
      "pz.it",
      "prato.it",
      "po.it",
      "ragusa.it",
      "rg.it",
      "ravenna.it",
      "ra.it",
      "reggio-calabria.it",
      "reggiocalabria.it",
      "rc.it",
      "reggio-emilia.it",
      "reggioemilia.it",
      "re.it",
      "rieti.it",
      "ri.it",
      "rimini.it",
      "rn.it",
      "roma.it",
      "rome.it",
      "rm.it",
      "rovigo.it",
      "ro.it",
      "salerno.it",
      "sa.it",
      "sassari.it",
      "ss.it",
      "savona.it",
      "sv.it",
      "siena.it",
      "si.it",
      "siracusa.it",
      "sr.it",
      "sondrio.it",
      "so.it",
      "taranto.it",
      "ta.it",
      "tempio-olbia.it",
      "tempioolbia.it",
      "olbia-tempio.it",
      "olbiatempio.it",
      "ot.it",
      "teramo.it",
      "te.it",
      "terni.it",
      "tr.it",
      "torino.it",
      "turin.it",
      "to.it",
      "trapani.it",
      "tp.it",
      "trento.it",
      "trentino.it",
      "tn.it",
      "treviso.it",
      "tv.it",
      "trieste.it",
      "ts.it",
      "udine.it",
      "ud.it",
      "varese.it",
      "va.it",
      "venezia.it",
      "venice.it",
      "ve.it",
      "verbania.it",
      "vb.it",
      "vercelli.it",
      "vc.it",
      "verona.it",
      "vr.it",
      "vibo-valentia.it",
      "vibovalentia.it",
      "vv.it",
      "vicenza.it",
      "vi.it",
      "viterbo.it",
      "vt.it",
      "je",
      "co.je",
      "org.je",
      "net.je",
      "sch.je",
      "gov.je",
      "jo",
      "com.jo",
      "org.jo",
      "net.jo",
      "edu.jo",
      "sch.jo",
      "gov.jo",
      "mil.jo",
      "name.jo",
      "jobs",
      "jp",
      "ac.jp",
      "ad.jp",
      "co.jp",
      "ed.jp",
      "go.jp",
      "gr.jp",
      "lg.jp",
      "ne.jp",
      "or.jp",
      "kg",
      "org.kg",
      "net.kg",
      "com.kg",
      "edu.kg",
      "gov.kg",
      "mil.kg",
      "ki",
      "edu.ki",
      "biz.ki",
      "net.ki",
      "org.ki",
      "gov.ki",
      "info.ki",
      "com.ki",
      "km",
      "org.km",
      "nom.km",
      "gov.km",
      "prd.km",
      "tm.km",
      "edu.km",
      "mil.km",
      "ass.km",
      "com.km",
      "coop.km",
      "asso.km",
      "presse.km",
      "medecin.km",
      "notaires.km",
      "pharmaciens.km",
      "veterinaire.km",
      "gouv.km",
      "kn",
      "net.kn",
      "org.kn",
      "edu.kn",
      "gov.kn",
      "com.kp",
      "edu.kp",
      "gov.kp",
      "org.kp",
      "rep.kp",
      "tra.kp",
      "kr",
      "ac.kr",
      "co.kr",
      "es.kr",
      "go.kr",
      "hs.kr",
      "kg.kr",
      "mil.kr",
      "ms.kr",
      "ne.kr",
      "or.kr",
      "pe.kr",
      "re.kr",
      "sc.kr",
      "busan.kr",
      "chungbuk.kr",
      "chungnam.kr",
      "daegu.kr",
      "daejeon.kr",
      "gangwon.kr",
      "gwangju.kr",
      "gyeongbuk.kr",
      "gyeonggi.kr",
      "gyeongnam.kr",
      "incheon.kr",
      "jeju.kr",
      "jeonbuk.kr",
      "jeonnam.kr",
      "seoul.kr",
      "ulsan.kr",
      "ky",
      "edu.ky",
      "gov.ky",
      "com.ky",
      "org.ky",
      "net.ky",
      "kz",
      "org.kz",
      "edu.kz",
      "net.kz",
      "gov.kz",
      "mil.kz",
      "com.kz",
      "la",
      "int.la",
      "net.la",
      "info.la",
      "edu.la",
      "gov.la",
      "per.la",
      "com.la",
      "org.la",
      "c.la",
      "com.lb",
      "edu.lb",
      "gov.lb",
      "net.lb",
      "org.lb",
      "lc",
      "com.lc",
      "net.lc",
      "co.lc",
      "org.lc",
      "edu.lc",
      "gov.lc",
      "li",
      "lk",
      "gov.lk",
      "sch.lk",
      "net.lk",
      "int.lk",
      "com.lk",
      "org.lk",
      "edu.lk",
      "ngo.lk",
      "soc.lk",
      "web.lk",
      "ltd.lk",
      "assn.lk",
      "grp.lk",
      "hotel.lk",
      "local",
      "com.lr",
      "edu.lr",
      "gov.lr",
      "org.lr",
      "net.lr",
      "ls",
      "co.ls",
      "org.ls",
      "lt",
      "gov.lt",
      "lu",
      "lv",
      "com.lv",
      "edu.lv",
      "gov.lv",
      "org.lv",
      "mil.lv",
      "id.lv",
      "net.lv",
      "asn.lv",
      "conf.lv",
      "ly",
      "com.ly",
      "net.ly",
      "gov.ly",
      "plc.ly",
      "edu.ly",
      "sch.ly",
      "med.ly",
      "org.ly",
      "id.ly",
      "ma",
      "co.ma",
      "net.ma",
      "gov.ma",
      "org.ma",
      "ac.ma",
      "press.ma",
      "mc",
      "tm.mc",
      "asso.mc",
      "md",
      "me",
      "co.me",
      "net.me",
      "org.me",
      "edu.me",
      "ac.me",
      "gov.me",
      "its.me",
      "priv.me",
      "mg",
      "org.mg",
      "nom.mg",
      "gov.mg",
      "prd.mg",
      "tm.mg",
      "edu.mg",
      "mil.mg",
      "com.mg",
      "mh",
      "mil",
      "mk",
      "com.mk",
      "org.mk",
      "net.mk",
      "edu.mk",
      "gov.mk",
      "inf.mk",
      "name.mk",
      "ml",
      "com.ml",
      "edu.ml",
      "gouv.ml",
      "gov.ml",
      "net.ml",
      "org.ml",
      "presse.ml",
      "mn",
      "gov.mn",
      "edu.mn",
      "org.mn",
      "mo",
      "com.mo",
      "net.mo",
      "org.mo",
      "edu.mo",
      "gov.mo",
      "mobi",
      "mp",
      "mq",
      "mr",
      "gov.mr",
      "ms",
      "mu",
      "com.mu",
      "net.mu",
      "org.mu",
      "gov.mu",
      "ac.mu",
      "co.mu",
      "or.mu",
      "museum",
      "academy.museum",
      "agriculture.museum",
      "air.museum",
      "airguard.museum",
      "alabama.museum",
      "alaska.museum",
      "amber.museum",
      "ambulance.museum",
      "american.museum",
      "americana.museum",
      "americanantiques.museum",
      "americanart.museum",
      "amsterdam.museum",
      "and.museum",
      "annefrank.museum",
      "anthro.museum",
      "anthropology.museum",
      "antiques.museum",
      "aquarium.museum",
      "arboretum.museum",
      "archaeological.museum",
      "archaeology.museum",
      "architecture.museum",
      "art.museum",
      "artanddesign.museum",
      "artcenter.museum",
      "artdeco.museum",
      "arteducation.museum",
      "artgallery.museum",
      "arts.museum",
      "artsandcrafts.museum",
      "asmatart.museum",
      "assassination.museum",
      "assisi.museum",
      "association.museum",
      "astronomy.museum",
      "atlanta.museum",
      "austin.museum",
      "australia.museum",
      "automotive.museum",
      "aviation.museum",
      "axis.museum",
      "badajoz.museum",
      "baghdad.museum",
      "bahn.museum",
      "bale.museum",
      "baltimore.museum",
      "barcelona.museum",
      "baseball.museum",
      "basel.museum",
      "baths.museum",
      "bauern.museum",
      "beauxarts.museum",
      "beeldengeluid.museum",
      "bellevue.museum",
      "bergbau.museum",
      "berkeley.museum",
      "berlin.museum",
      "bern.museum",
      "bible.museum",
      "bilbao.museum",
      "bill.museum",
      "birdart.museum",
      "birthplace.museum",
      "bonn.museum",
      "boston.museum",
      "botanical.museum",
      "botanicalgarden.museum",
      "botanicgarden.museum",
      "botany.museum",
      "brandywinevalley.museum",
      "brasil.museum",
      "bristol.museum",
      "british.museum",
      "britishcolumbia.museum",
      "broadcast.museum",
      "brunel.museum",
      "brussel.museum",
      "brussels.museum",
      "bruxelles.museum",
      "building.museum",
      "burghof.museum",
      "bus.museum",
      "bushey.museum",
      "cadaques.museum",
      "california.museum",
      "cambridge.museum",
      "can.museum",
      "canada.museum",
      "capebreton.museum",
      "carrier.museum",
      "cartoonart.museum",
      "casadelamoneda.museum",
      "castle.museum",
      "castres.museum",
      "celtic.museum",
      "center.museum",
      "chattanooga.museum",
      "cheltenham.museum",
      "chesapeakebay.museum",
      "chicago.museum",
      "children.museum",
      "childrens.museum",
      "childrensgarden.museum",
      "chiropractic.museum",
      "chocolate.museum",
      "christiansburg.museum",
      "cincinnati.museum",
      "cinema.museum",
      "circus.museum",
      "civilisation.museum",
      "civilization.museum",
      "civilwar.museum",
      "clinton.museum",
      "clock.museum",
      "coal.museum",
      "coastaldefence.museum",
      "cody.museum",
      "coldwar.museum",
      "collection.museum",
      "colonialwilliamsburg.museum",
      "coloradoplateau.museum",
      "columbia.museum",
      "columbus.museum",
      "communication.museum",
      "communications.museum",
      "community.museum",
      "computer.museum",
      "computerhistory.museum",
      "comunica\u00e7\u00f5es.museum",
      "xn--comunicaes-v6a2o.museum",
      "contemporary.museum",
      "contemporaryart.museum",
      "convent.museum",
      "copenhagen.museum",
      "corporation.museum",
      "correios-e-telecomunica\u00e7\u00f5es.museum",
      "xn--correios-e-telecomunicaes-ghc29a.museum",
      "corvette.museum",
      "costume.museum",
      "countryestate.museum",
      "county.museum",
      "crafts.museum",
      "cranbrook.museum",
      "creation.museum",
      "cultural.museum",
      "culturalcenter.museum",
      "culture.museum",
      "cyber.museum",
      "cymru.museum",
      "dali.museum",
      "dallas.museum",
      "database.museum",
      "ddr.museum",
      "decorativearts.museum",
      "delaware.museum",
      "delmenhorst.museum",
      "denmark.museum",
      "depot.museum",
      "design.museum",
      "detroit.museum",
      "dinosaur.museum",
      "discovery.museum",
      "dolls.museum",
      "donostia.museum",
      "durham.museum",
      "eastafrica.museum",
      "eastcoast.museum",
      "education.museum",
      "educational.museum",
      "egyptian.museum",
      "eisenbahn.museum",
      "elburg.museum",
      "elvendrell.museum",
      "embroidery.museum",
      "encyclopedic.museum",
      "england.museum",
      "entomology.museum",
      "environment.museum",
      "environmentalconservation.museum",
      "epilepsy.museum",
      "essex.museum",
      "estate.museum",
      "ethnology.museum",
      "exeter.museum",
      "exhibition.museum",
      "family.museum",
      "farm.museum",
      "farmequipment.museum",
      "farmers.museum",
      "farmstead.museum",
      "field.museum",
      "figueres.museum",
      "filatelia.museum",
      "film.museum",
      "fineart.museum",
      "finearts.museum",
      "finland.museum",
      "flanders.museum",
      "florida.museum",
      "force.museum",
      "fortmissoula.museum",
      "fortworth.museum",
      "foundation.museum",
      "francaise.museum",
      "frankfurt.museum",
      "franziskaner.museum",
      "freemasonry.museum",
      "freiburg.museum",
      "fribourg.museum",
      "frog.museum",
      "fundacio.museum",
      "furniture.museum",
      "gallery.museum",
      "garden.museum",
      "gateway.museum",
      "geelvinck.museum",
      "gemological.museum",
      "geology.museum",
      "georgia.museum",
      "giessen.museum",
      "glas.museum",
      "glass.museum",
      "gorge.museum",
      "grandrapids.museum",
      "graz.museum",
      "guernsey.museum",
      "halloffame.museum",
      "hamburg.museum",
      "handson.museum",
      "harvestcelebration.museum",
      "hawaii.museum",
      "health.museum",
      "heimatunduhren.museum",
      "hellas.museum",
      "helsinki.museum",
      "hembygdsforbund.museum",
      "heritage.museum",
      "histoire.museum",
      "historical.museum",
      "historicalsociety.museum",
      "historichouses.museum",
      "historisch.museum",
      "historisches.museum",
      "history.museum",
      "historyofscience.museum",
      "horology.museum",
      "house.museum",
      "humanities.museum",
      "illustration.museum",
      "imageandsound.museum",
      "indian.museum",
      "indiana.museum",
      "indianapolis.museum",
      "indianmarket.museum",
      "intelligence.museum",
      "interactive.museum",
      "iraq.museum",
      "iron.museum",
      "isleofman.museum",
      "jamison.museum",
      "jefferson.museum",
      "jerusalem.museum",
      "jewelry.museum",
      "jewish.museum",
      "jewishart.museum",
      "jfk.museum",
      "journalism.museum",
      "judaica.museum",
      "judygarland.museum",
      "juedisches.museum",
      "juif.museum",
      "karate.museum",
      "karikatur.museum",
      "kids.museum",
      "koebenhavn.museum",
      "koeln.museum",
      "kunst.museum",
      "kunstsammlung.museum",
      "kunstunddesign.museum",
      "labor.museum",
      "labour.museum",
      "lajolla.museum",
      "lancashire.museum",
      "landes.museum",
      "lans.museum",
      "l\u00e4ns.museum",
      "xn--lns-qla.museum",
      "larsson.museum",
      "lewismiller.museum",
      "lincoln.museum",
      "linz.museum",
      "living.museum",
      "livinghistory.museum",
      "localhistory.museum",
      "london.museum",
      "losangeles.museum",
      "louvre.museum",
      "loyalist.museum",
      "lucerne.museum",
      "luxembourg.museum",
      "luzern.museum",
      "mad.museum",
      "madrid.museum",
      "mallorca.museum",
      "manchester.museum",
      "mansion.museum",
      "mansions.museum",
      "manx.museum",
      "marburg.museum",
      "maritime.museum",
      "maritimo.museum",
      "maryland.museum",
      "marylhurst.museum",
      "media.museum",
      "medical.museum",
      "medizinhistorisches.museum",
      "meeres.museum",
      "memorial.museum",
      "mesaverde.museum",
      "michigan.museum",
      "midatlantic.museum",
      "military.museum",
      "mill.museum",
      "miners.museum",
      "mining.museum",
      "minnesota.museum",
      "missile.museum",
      "missoula.museum",
      "modern.museum",
      "moma.museum",
      "money.museum",
      "monmouth.museum",
      "monticello.museum",
      "montreal.museum",
      "moscow.museum",
      "motorcycle.museum",
      "muenchen.museum",
      "muenster.museum",
      "mulhouse.museum",
      "muncie.museum",
      "museet.museum",
      "museumcenter.museum",
      "museumvereniging.museum",
      "music.museum",
      "national.museum",
      "nationalfirearms.museum",
      "nationalheritage.museum",
      "nativeamerican.museum",
      "naturalhistory.museum",
      "naturalhistorymuseum.museum",
      "naturalsciences.museum",
      "nature.museum",
      "naturhistorisches.museum",
      "natuurwetenschappen.museum",
      "naumburg.museum",
      "naval.museum",
      "nebraska.museum",
      "neues.museum",
      "newhampshire.museum",
      "newjersey.museum",
      "newmexico.museum",
      "newport.museum",
      "newspaper.museum",
      "newyork.museum",
      "niepce.museum",
      "norfolk.museum",
      "north.museum",
      "nrw.museum",
      "nuernberg.museum",
      "nuremberg.museum",
      "nyc.museum",
      "nyny.museum",
      "oceanographic.museum",
      "oceanographique.museum",
      "omaha.museum",
      "online.museum",
      "ontario.museum",
      "openair.museum",
      "oregon.museum",
      "oregontrail.museum",
      "otago.museum",
      "oxford.museum",
      "pacific.museum",
      "paderborn.museum",
      "palace.museum",
      "paleo.museum",
      "palmsprings.museum",
      "panama.museum",
      "paris.museum",
      "pasadena.museum",
      "pharmacy.museum",
      "philadelphia.museum",
      "philadelphiaarea.museum",
      "philately.museum",
      "phoenix.museum",
      "photography.museum",
      "pilots.museum",
      "pittsburgh.museum",
      "planetarium.museum",
      "plantation.museum",
      "plants.museum",
      "plaza.museum",
      "portal.museum",
      "portland.museum",
      "portlligat.museum",
      "posts-and-telecommunications.museum",
      "preservation.museum",
      "presidio.museum",
      "press.museum",
      "project.museum",
      "public.museum",
      "pubol.museum",
      "quebec.museum",
      "railroad.museum",
      "railway.museum",
      "research.museum",
      "resistance.museum",
      "riodejaneiro.museum",
      "rochester.museum",
      "rockart.museum",
      "roma.museum",
      "russia.museum",
      "saintlouis.museum",
      "salem.museum",
      "salvadordali.museum",
      "salzburg.museum",
      "sandiego.museum",
      "sanfrancisco.museum",
      "santabarbara.museum",
      "santacruz.museum",
      "santafe.museum",
      "saskatchewan.museum",
      "satx.museum",
      "savannahga.museum",
      "schlesisches.museum",
      "schoenbrunn.museum",
      "schokoladen.museum",
      "school.museum",
      "schweiz.museum",
      "science.museum",
      "scienceandhistory.museum",
      "scienceandindustry.museum",
      "sciencecenter.museum",
      "sciencecenters.museum",
      "science-fiction.museum",
      "sciencehistory.museum",
      "sciences.museum",
      "sciencesnaturelles.museum",
      "scotland.museum",
      "seaport.museum",
      "settlement.museum",
      "settlers.museum",
      "shell.museum",
      "sherbrooke.museum",
      "sibenik.museum",
      "silk.museum",
      "ski.museum",
      "skole.museum",
      "society.museum",
      "sologne.museum",
      "soundandvision.museum",
      "southcarolina.museum",
      "southwest.museum",
      "space.museum",
      "spy.museum",
      "square.museum",
      "stadt.museum",
      "stalbans.museum",
      "starnberg.museum",
      "state.museum",
      "stateofdelaware.museum",
      "station.museum",
      "steam.museum",
      "steiermark.museum",
      "stjohn.museum",
      "stockholm.museum",
      "stpetersburg.museum",
      "stuttgart.museum",
      "suisse.museum",
      "surgeonshall.museum",
      "surrey.museum",
      "svizzera.museum",
      "sweden.museum",
      "sydney.museum",
      "tank.museum",
      "tcm.museum",
      "technology.museum",
      "telekommunikation.museum",
      "television.museum",
      "texas.museum",
      "textile.museum",
      "theater.museum",
      "time.museum",
      "timekeeping.museum",
      "topology.museum",
      "torino.museum",
      "touch.museum",
      "town.museum",
      "transport.museum",
      "tree.museum",
      "trolley.museum",
      "trust.museum",
      "trustee.museum",
      "uhren.museum",
      "ulm.museum",
      "undersea.museum",
      "university.museum",
      "usa.museum",
      "usantiques.museum",
      "usarts.museum",
      "uscountryestate.museum",
      "usculture.museum",
      "usdecorativearts.museum",
      "usgarden.museum",
      "ushistory.museum",
      "ushuaia.museum",
      "uslivinghistory.museum",
      "utah.museum",
      "uvic.museum",
      "valley.museum",
      "vantaa.museum",
      "versailles.museum",
      "viking.museum",
      "village.museum",
      "virginia.museum",
      "virtual.museum",
      "virtuel.museum",
      "vlaanderen.museum",
      "volkenkunde.museum",
      "wales.museum",
      "wallonie.museum",
      "war.museum",
      "washingtondc.museum",
      "watchandclock.museum",
      "watch-and-clock.museum",
      "western.museum",
      "westfalen.museum",
      "whaling.museum",
      "wildlife.museum",
      "williamsburg.museum",
      "windmill.museum",
      "workshop.museum",
      "york.museum",
      "yorkshire.museum",
      "yosemite.museum",
      "youth.museum",
      "zoological.museum",
      "zoology.museum",
      "\u05d9\u05e8\u05d5\u05e9\u05dc\u05d9\u05dd.museum",
      "xn--9dbhblg6di.museum",
      "\u0438\u043a\u043e\u043c.museum",
      "xn--h1aegh.museum",
      "mv",
      "aero.mv",
      "biz.mv",
      "com.mv",
      "coop.mv",
      "edu.mv",
      "gov.mv",
      "info.mv",
      "int.mv",
      "mil.mv",
      "museum.mv",
      "name.mv",
      "net.mv",
      "org.mv",
      "pro.mv",
      "mw",
      "ac.mw",
      "biz.mw",
      "co.mw",
      "com.mw",
      "coop.mw",
      "edu.mw",
      "gov.mw",
      "int.mw",
      "museum.mw",
      "net.mw",
      "org.mw",
      "mx",
      "com.mx",
      "org.mx",
      "gob.mx",
      "edu.mx",
      "net.mx",
      "my",
      "com.my",
      "net.my",
      "org.my",
      "gov.my",
      "edu.my",
      "mil.my",
      "name.my",
      "na",
      "info.na",
      "pro.na",
      "name.na",
      "school.na",
      "or.na",
      "dr.na",
      "us.na",
      "mx.na",
      "ca.na",
      "in.na",
      "cc.na",
      "tv.na",
      "ws.na",
      "mobi.na",
      "co.na",
      "com.na",
      "org.na",
      "name",
      "nc",
      "asso.nc",
      "ne",
      "net",
      "gb.net",
      "se.net",
      "uk.net",
      "za.net",
      "nf",
      "com.nf",
      "net.nf",
      "per.nf",
      "rec.nf",
      "web.nf",
      "arts.nf",
      "firm.nf",
      "info.nf",
      "other.nf",
      "store.nf",
      "ac.ng",
      "com.ng",
      "edu.ng",
      "gov.ng",
      "net.ng",
      "org.ng",
      "nl",
      "bv.nl",
      "no",
      "fhs.no",
      "vgs.no",
      "fylkesbibl.no",
      "folkebibl.no",
      "museum.no",
      "idrett.no",
      "priv.no",
      "mil.no",
      "stat.no",
      "dep.no",
      "kommune.no",
      "herad.no",
      "aa.no",
      "ah.no",
      "bu.no",
      "fm.no",
      "hl.no",
      "hm.no",
      "jan-mayen.no",
      "mr.no",
      "nl.no",
      "nt.no",
      "of.no",
      "ol.no",
      "oslo.no",
      "rl.no",
      "sf.no",
      "st.no",
      "svalbard.no",
      "tm.no",
      "tr.no",
      "va.no",
      "vf.no",
      "gs.aa.no",
      "gs.ah.no",
      "gs.bu.no",
      "gs.fm.no",
      "gs.hl.no",
      "gs.hm.no",
      "gs.jan-mayen.no",
      "gs.mr.no",
      "gs.nl.no",
      "gs.nt.no",
      "gs.of.no",
      "gs.ol.no",
      "gs.oslo.no",
      "gs.rl.no",
      "gs.sf.no",
      "gs.st.no",
      "gs.svalbard.no",
      "gs.tm.no",
      "gs.tr.no",
      "gs.va.no",
      "gs.vf.no",
      "akrehamn.no",
      "\u00e5krehamn.no",
      "xn--krehamn-dxa.no",
      "algard.no",
      "\u00e5lg\u00e5rd.no",
      "xn--lgrd-poac.no",
      "arna.no",
      "brumunddal.no",
      "bryne.no",
      "bronnoysund.no",
      "br\u00f8nn\u00f8ysund.no",
      "xn--brnnysund-m8ac.no",
      "drobak.no",
      "dr\u00f8bak.no",
      "xn--drbak-wua.no",
      "egersund.no",
      "fetsund.no",
      "floro.no",
      "flor\u00f8.no",
      "xn--flor-jra.no",
      "fredrikstad.no",
      "hokksund.no",
      "honefoss.no",
      "h\u00f8nefoss.no",
      "xn--hnefoss-q1a.no",
      "jessheim.no",
      "jorpeland.no",
      "j\u00f8rpeland.no",
      "xn--jrpeland-54a.no",
      "kirkenes.no",
      "kopervik.no",
      "krokstadelva.no",
      "langevag.no",
      "langev\u00e5g.no",
      "xn--langevg-jxa.no",
      "leirvik.no",
      "mjondalen.no",
      "mj\u00f8ndalen.no",
      "xn--mjndalen-64a.no",
      "mo-i-rana.no",
      "mosjoen.no",
      "mosj\u00f8en.no",
      "xn--mosjen-eya.no",
      "nesoddtangen.no",
      "orkanger.no",
      "osoyro.no",
      "os\u00f8yro.no",
      "xn--osyro-wua.no",
      "raholt.no",
      "r\u00e5holt.no",
      "xn--rholt-mra.no",
      "sandnessjoen.no",
      "sandnessj\u00f8en.no",
      "xn--sandnessjen-ogb.no",
      "skedsmokorset.no",
      "slattum.no",
      "spjelkavik.no",
      "stathelle.no",
      "stavern.no",
      "stjordalshalsen.no",
      "stj\u00f8rdalshalsen.no",
      "xn--stjrdalshalsen-sqb.no",
      "tananger.no",
      "tranby.no",
      "vossevangen.no",
      "afjord.no",
      "\u00e5fjord.no",
      "xn--fjord-lra.no",
      "agdenes.no",
      "al.no",
      "\u00e5l.no",
      "xn--l-1fa.no",
      "alesund.no",
      "\u00e5lesund.no",
      "xn--lesund-hua.no",
      "alstahaug.no",
      "alta.no",
      "\u00e1lt\u00e1.no",
      "xn--lt-liac.no",
      "alaheadju.no",
      "\u00e1laheadju.no",
      "xn--laheadju-7ya.no",
      "alvdal.no",
      "amli.no",
      "\u00e5mli.no",
      "xn--mli-tla.no",
      "amot.no",
      "\u00e5mot.no",
      "xn--mot-tla.no",
      "andebu.no",
      "andoy.no",
      "and\u00f8y.no",
      "xn--andy-ira.no",
      "andasuolo.no",
      "ardal.no",
      "\u00e5rdal.no",
      "xn--rdal-poa.no",
      "aremark.no",
      "arendal.no",
      "\u00e5s.no",
      "xn--s-1fa.no",
      "aseral.no",
      "\u00e5seral.no",
      "xn--seral-lra.no",
      "asker.no",
      "askim.no",
      "askvoll.no",
      "askoy.no",
      "ask\u00f8y.no",
      "xn--asky-ira.no",
      "asnes.no",
      "\u00e5snes.no",
      "xn--snes-poa.no",
      "audnedaln.no",
      "aukra.no",
      "aure.no",
      "aurland.no",
      "aurskog-holand.no",
      "aurskog-h\u00f8land.no",
      "xn--aurskog-hland-jnb.no",
      "austevoll.no",
      "austrheim.no",
      "averoy.no",
      "aver\u00f8y.no",
      "xn--avery-yua.no",
      "balestrand.no",
      "ballangen.no",
      "balat.no",
      "b\u00e1l\u00e1t.no",
      "xn--blt-elab.no",
      "balsfjord.no",
      "bahccavuotna.no",
      "b\u00e1hccavuotna.no",
      "xn--bhccavuotna-k7a.no",
      "bamble.no",
      "bardu.no",
      "beardu.no",
      "beiarn.no",
      "bajddar.no",
      "b\u00e1jddar.no",
      "xn--bjddar-pta.no",
      "baidar.no",
      "b\u00e1id\u00e1r.no",
      "xn--bidr-5nac.no",
      "berg.no",
      "bergen.no",
      "berlevag.no",
      "berlev\u00e5g.no",
      "xn--berlevg-jxa.no",
      "bearalvahki.no",
      "bearalv\u00e1hki.no",
      "xn--bearalvhki-y4a.no",
      "bindal.no",
      "birkenes.no",
      "bjarkoy.no",
      "bjark\u00f8y.no",
      "xn--bjarky-fya.no",
      "bjerkreim.no",
      "bjugn.no",
      "bodo.no",
      "bod\u00f8.no",
      "xn--bod-2na.no",
      "badaddja.no",
      "b\u00e5d\u00e5ddj\u00e5.no",
      "xn--bdddj-mrabd.no",
      "budejju.no",
      "bokn.no",
      "bremanger.no",
      "bronnoy.no",
      "br\u00f8nn\u00f8y.no",
      "xn--brnny-wuac.no",
      "bygland.no",
      "bykle.no",
      "barum.no",
      "b\u00e6rum.no",
      "xn--brum-voa.no",
      "bo.telemark.no",
      "b\u00f8.telemark.no",
      "xn--b-5ga.telemark.no",
      "bo.nordland.no",
      "b\u00f8.nordland.no",
      "xn--b-5ga.nordland.no",
      "bievat.no",
      "biev\u00e1t.no",
      "xn--bievt-0qa.no",
      "bomlo.no",
      "b\u00f8mlo.no",
      "xn--bmlo-gra.no",
      "batsfjord.no",
      "b\u00e5tsfjord.no",
      "xn--btsfjord-9za.no",
      "bahcavuotna.no",
      "b\u00e1hcavuotna.no",
      "xn--bhcavuotna-s4a.no",
      "dovre.no",
      "drammen.no",
      "drangedal.no",
      "dyroy.no",
      "dyr\u00f8y.no",
      "xn--dyry-ira.no",
      "donna.no",
      "d\u00f8nna.no",
      "xn--dnna-gra.no",
      "eid.no",
      "eidfjord.no",
      "eidsberg.no",
      "eidskog.no",
      "eidsvoll.no",
      "eigersund.no",
      "elverum.no",
      "enebakk.no",
      "engerdal.no",
      "etne.no",
      "etnedal.no",
      "evenes.no",
      "evenassi.no",
      "even\u00e1\u0161\u0161i.no",
      "xn--eveni-0qa01ga.no",
      "evje-og-hornnes.no",
      "farsund.no",
      "fauske.no",
      "fuossko.no",
      "fuoisku.no",
      "fedje.no",
      "fet.no",
      "finnoy.no",
      "finn\u00f8y.no",
      "xn--finny-yua.no",
      "fitjar.no",
      "fjaler.no",
      "fjell.no",
      "flakstad.no",
      "flatanger.no",
      "flekkefjord.no",
      "flesberg.no",
      "flora.no",
      "fla.no",
      "fl\u00e5.no",
      "xn--fl-zia.no",
      "folldal.no",
      "forsand.no",
      "fosnes.no",
      "frei.no",
      "frogn.no",
      "froland.no",
      "frosta.no",
      "frana.no",
      "fr\u00e6na.no",
      "xn--frna-woa.no",
      "froya.no",
      "fr\u00f8ya.no",
      "xn--frya-hra.no",
      "fusa.no",
      "fyresdal.no",
      "forde.no",
      "f\u00f8rde.no",
      "xn--frde-gra.no",
      "gamvik.no",
      "gangaviika.no",
      "g\u00e1\u014bgaviika.no",
      "xn--ggaviika-8ya47h.no",
      "gaular.no",
      "gausdal.no",
      "gildeskal.no",
      "gildesk\u00e5l.no",
      "xn--gildeskl-g0a.no",
      "giske.no",
      "gjemnes.no",
      "gjerdrum.no",
      "gjerstad.no",
      "gjesdal.no",
      "gjovik.no",
      "gj\u00f8vik.no",
      "xn--gjvik-wua.no",
      "gloppen.no",
      "gol.no",
      "gran.no",
      "grane.no",
      "granvin.no",
      "gratangen.no",
      "grimstad.no",
      "grong.no",
      "kraanghke.no",
      "kr\u00e5anghke.no",
      "xn--kranghke-b0a.no",
      "grue.no",
      "gulen.no",
      "hadsel.no",
      "halden.no",
      "halsa.no",
      "hamar.no",
      "hamaroy.no",
      "habmer.no",
      "h\u00e1bmer.no",
      "xn--hbmer-xqa.no",
      "hapmir.no",
      "h\u00e1pmir.no",
      "xn--hpmir-xqa.no",
      "hammerfest.no",
      "hammarfeasta.no",
      "h\u00e1mm\u00e1rfeasta.no",
      "xn--hmmrfeasta-s4ac.no",
      "haram.no",
      "hareid.no",
      "harstad.no",
      "hasvik.no",
      "aknoluokta.no",
      "\u00e1k\u014boluokta.no",
      "xn--koluokta-7ya57h.no",
      "hattfjelldal.no",
      "aarborte.no",
      "haugesund.no",
      "hemne.no",
      "hemnes.no",
      "hemsedal.no",
      "heroy.more-og-romsdal.no",
      "her\u00f8y.m\u00f8re-og-romsdal.no",
      "xn--hery-ira.xn--mre-og-romsdal-qqb.no",
      "heroy.nordland.no",
      "her\u00f8y.nordland.no",
      "xn--hery-ira.nordland.no",
      "hitra.no",
      "hjartdal.no",
      "hjelmeland.no",
      "hobol.no",
      "hob\u00f8l.no",
      "xn--hobl-ira.no",
      "hof.no",
      "hol.no",
      "hole.no",
      "holmestrand.no",
      "holtalen.no",
      "holt\u00e5len.no",
      "xn--holtlen-hxa.no",
      "hornindal.no",
      "horten.no",
      "hurdal.no",
      "hurum.no",
      "hvaler.no",
      "hyllestad.no",
      "hagebostad.no",
      "h\u00e6gebostad.no",
      "xn--hgebostad-g3a.no",
      "hoyanger.no",
      "h\u00f8yanger.no",
      "xn--hyanger-q1a.no",
      "hoylandet.no",
      "h\u00f8ylandet.no",
      "xn--hylandet-54a.no",
      "ha.no",
      "h\u00e5.no",
      "xn--h-2fa.no",
      "ibestad.no",
      "inderoy.no",
      "inder\u00f8y.no",
      "xn--indery-fya.no",
      "iveland.no",
      "jevnaker.no",
      "jondal.no",
      "jolster.no",
      "j\u00f8lster.no",
      "xn--jlster-bya.no",
      "karasjok.no",
      "karasjohka.no",
      "k\u00e1r\u00e1\u0161johka.no",
      "xn--krjohka-hwab49j.no",
      "karlsoy.no",
      "galsa.no",
      "g\u00e1ls\u00e1.no",
      "xn--gls-elac.no",
      "karmoy.no",
      "karm\u00f8y.no",
      "xn--karmy-yua.no",
      "kautokeino.no",
      "guovdageaidnu.no",
      "klepp.no",
      "klabu.no",
      "kl\u00e6bu.no",
      "xn--klbu-woa.no",
      "kongsberg.no",
      "kongsvinger.no",
      "kragero.no",
      "krager\u00f8.no",
      "xn--krager-gya.no",
      "kristiansand.no",
      "kristiansund.no",
      "krodsherad.no",
      "kr\u00f8dsherad.no",
      "xn--krdsherad-m8a.no",
      "kvalsund.no",
      "rahkkeravju.no",
      "r\u00e1hkker\u00e1vju.no",
      "xn--rhkkervju-01af.no",
      "kvam.no",
      "kvinesdal.no",
      "kvinnherad.no",
      "kviteseid.no",
      "kvitsoy.no",
      "kvits\u00f8y.no",
      "xn--kvitsy-fya.no",
      "kvafjord.no",
      "kv\u00e6fjord.no",
      "xn--kvfjord-nxa.no",
      "giehtavuoatna.no",
      "kvanangen.no",
      "kv\u00e6nangen.no",
      "xn--kvnangen-k0a.no",
      "navuotna.no",
      "n\u00e1vuotna.no",
      "xn--nvuotna-hwa.no",
      "kafjord.no",
      "k\u00e5fjord.no",
      "xn--kfjord-iua.no",
      "gaivuotna.no",
      "g\u00e1ivuotna.no",
      "xn--givuotna-8ya.no",
      "larvik.no",
      "lavangen.no",
      "lavagis.no",
      "loabat.no",
      "loab\u00e1t.no",
      "xn--loabt-0qa.no",
      "lebesby.no",
      "davvesiida.no",
      "leikanger.no",
      "leirfjord.no",
      "leka.no",
      "leksvik.no",
      "lenvik.no",
      "leangaviika.no",
      "lea\u014bgaviika.no",
      "xn--leagaviika-52b.no",
      "lesja.no",
      "levanger.no",
      "lier.no",
      "lierne.no",
      "lillehammer.no",
      "lillesand.no",
      "lindesnes.no",
      "lindas.no",
      "lind\u00e5s.no",
      "xn--linds-pra.no",
      "lom.no",
      "loppa.no",
      "lahppi.no",
      "l\u00e1hppi.no",
      "xn--lhppi-xqa.no",
      "lund.no",
      "lunner.no",
      "luroy.no",
      "lur\u00f8y.no",
      "xn--lury-ira.no",
      "luster.no",
      "lyngdal.no",
      "lyngen.no",
      "ivgu.no",
      "lardal.no",
      "lerdal.no",
      "l\u00e6rdal.no",
      "xn--lrdal-sra.no",
      "lodingen.no",
      "l\u00f8dingen.no",
      "xn--ldingen-q1a.no",
      "lorenskog.no",
      "l\u00f8renskog.no",
      "xn--lrenskog-54a.no",
      "loten.no",
      "l\u00f8ten.no",
      "xn--lten-gra.no",
      "malvik.no",
      "masoy.no",
      "m\u00e5s\u00f8y.no",
      "xn--msy-ula0h.no",
      "muosat.no",
      "muos\u00e1t.no",
      "xn--muost-0qa.no",
      "mandal.no",
      "marker.no",
      "marnardal.no",
      "masfjorden.no",
      "meland.no",
      "meldal.no",
      "melhus.no",
      "meloy.no",
      "mel\u00f8y.no",
      "xn--mely-ira.no",
      "meraker.no",
      "mer\u00e5ker.no",
      "xn--merker-kua.no",
      "moareke.no",
      "mo\u00e5reke.no",
      "xn--moreke-jua.no",
      "midsund.no",
      "midtre-gauldal.no",
      "modalen.no",
      "modum.no",
      "molde.no",
      "moskenes.no",
      "moss.no",
      "mosvik.no",
      "malselv.no",
      "m\u00e5lselv.no",
      "xn--mlselv-iua.no",
      "malatvuopmi.no",
      "m\u00e1latvuopmi.no",
      "xn--mlatvuopmi-s4a.no",
      "namdalseid.no",
      "aejrie.no",
      "namsos.no",
      "namsskogan.no",
      "naamesjevuemie.no",
      "n\u00e5\u00e5mesjevuemie.no",
      "xn--nmesjevuemie-tcba.no",
      "laakesvuemie.no",
      "nannestad.no",
      "narvik.no",
      "narviika.no",
      "naustdal.no",
      "nedre-eiker.no",
      "nes.akershus.no",
      "nes.buskerud.no",
      "nesna.no",
      "nesodden.no",
      "nesseby.no",
      "unjarga.no",
      "unj\u00e1rga.no",
      "xn--unjrga-rta.no",
      "nesset.no",
      "nissedal.no",
      "nittedal.no",
      "nord-aurdal.no",
      "nord-fron.no",
      "nord-odal.no",
      "norddal.no",
      "nordkapp.no",
      "davvenjarga.no",
      "davvenj\u00e1rga.no",
      "xn--davvenjrga-y4a.no",
      "nordre-land.no",
      "nordreisa.no",
      "raisa.no",
      "r\u00e1isa.no",
      "xn--risa-5na.no",
      "nore-og-uvdal.no",
      "notodden.no",
      "naroy.no",
      "n\u00e6r\u00f8y.no",
      "xn--nry-yla5g.no",
      "notteroy.no",
      "n\u00f8tter\u00f8y.no",
      "xn--nttery-byae.no",
      "odda.no",
      "oksnes.no",
      "\u00f8ksnes.no",
      "xn--ksnes-uua.no",
      "oppdal.no",
      "oppegard.no",
      "oppeg\u00e5rd.no",
      "xn--oppegrd-ixa.no",
      "orkdal.no",
      "orland.no",
      "\u00f8rland.no",
      "xn--rland-uua.no",
      "orskog.no",
      "\u00f8rskog.no",
      "xn--rskog-uua.no",
      "orsta.no",
      "\u00f8rsta.no",
      "xn--rsta-fra.no",
      "os.hedmark.no",
      "os.hordaland.no",
      "osen.no",
      "osteroy.no",
      "oster\u00f8y.no",
      "xn--ostery-fya.no",
      "ostre-toten.no",
      "\u00f8stre-toten.no",
      "xn--stre-toten-zcb.no",
      "overhalla.no",
      "ovre-eiker.no",
      "\u00f8vre-eiker.no",
      "xn--vre-eiker-k8a.no",
      "oyer.no",
      "\u00f8yer.no",
      "xn--yer-zna.no",
      "oygarden.no",
      "\u00f8ygarden.no",
      "xn--ygarden-p1a.no",
      "oystre-slidre.no",
      "\u00f8ystre-slidre.no",
      "xn--ystre-slidre-ujb.no",
      "porsanger.no",
      "porsangu.no",
      "pors\u00e1\u014bgu.no",
      "xn--porsgu-sta26f.no",
      "porsgrunn.no",
      "radoy.no",
      "rad\u00f8y.no",
      "xn--rady-ira.no",
      "rakkestad.no",
      "rana.no",
      "ruovat.no",
      "randaberg.no",
      "rauma.no",
      "rendalen.no",
      "rennebu.no",
      "rennesoy.no",
      "rennes\u00f8y.no",
      "xn--rennesy-v1a.no",
      "rindal.no",
      "ringebu.no",
      "ringerike.no",
      "ringsaker.no",
      "rissa.no",
      "risor.no",
      "ris\u00f8r.no",
      "xn--risr-ira.no",
      "roan.no",
      "rollag.no",
      "rygge.no",
      "ralingen.no",
      "r\u00e6lingen.no",
      "xn--rlingen-mxa.no",
      "rodoy.no",
      "r\u00f8d\u00f8y.no",
      "xn--rdy-0nab.no",
      "romskog.no",
      "r\u00f8mskog.no",
      "xn--rmskog-bya.no",
      "roros.no",
      "r\u00f8ros.no",
      "xn--rros-gra.no",
      "rost.no",
      "r\u00f8st.no",
      "xn--rst-0na.no",
      "royken.no",
      "r\u00f8yken.no",
      "xn--ryken-vua.no",
      "royrvik.no",
      "r\u00f8yrvik.no",
      "xn--ryrvik-bya.no",
      "rade.no",
      "r\u00e5de.no",
      "xn--rde-ula.no",
      "salangen.no",
      "siellak.no",
      "saltdal.no",
      "salat.no",
      "s\u00e1l\u00e1t.no",
      "xn--slt-elab.no",
      "s\u00e1lat.no",
      "xn--slat-5na.no",
      "samnanger.no",
      "sande.more-og-romsdal.no",
      "sande.m\u00f8re-og-romsdal.no",
      "sande.xn--mre-og-romsdal-qqb.no",
      "sande.vestfold.no",
      "sandefjord.no",
      "sandnes.no",
      "sandoy.no",
      "sand\u00f8y.no",
      "xn--sandy-yua.no",
      "sarpsborg.no",
      "sauda.no",
      "sauherad.no",
      "sel.no",
      "selbu.no",
      "selje.no",
      "seljord.no",
      "sigdal.no",
      "siljan.no",
      "sirdal.no",
      "skaun.no",
      "skedsmo.no",
      "ski.no",
      "skien.no",
      "skiptvet.no",
      "skjervoy.no",
      "skjerv\u00f8y.no",
      "xn--skjervy-v1a.no",
      "skierva.no",
      "skierv\u00e1.no",
      "xn--skierv-uta.no",
      "skjak.no",
      "skj\u00e5k.no",
      "xn--skjk-soa.no",
      "skodje.no",
      "skanland.no",
      "sk\u00e5nland.no",
      "xn--sknland-fxa.no",
      "skanit.no",
      "sk\u00e1nit.no",
      "xn--sknit-yqa.no",
      "smola.no",
      "sm\u00f8la.no",
      "xn--smla-hra.no",
      "snillfjord.no",
      "snasa.no",
      "sn\u00e5sa.no",
      "xn--snsa-roa.no",
      "snoasa.no",
      "snaase.no",
      "sn\u00e5ase.no",
      "xn--snase-nra.no",
      "sogndal.no",
      "sokndal.no",
      "sola.no",
      "solund.no",
      "songdalen.no",
      "sortland.no",
      "spydeberg.no",
      "stange.no",
      "stavanger.no",
      "steigen.no",
      "steinkjer.no",
      "stjordal.no",
      "stj\u00f8rdal.no",
      "xn--stjrdal-s1a.no",
      "stokke.no",
      "stor-elvdal.no",
      "stord.no",
      "stordal.no",
      "storfjord.no",
      "omasvuotna.no",
      "strand.no",
      "stranda.no",
      "stryn.no",
      "sula.no",
      "suldal.no",
      "sund.no",
      "sunndal.no",
      "surnadal.no",
      "sveio.no",
      "svelvik.no",
      "sykkylven.no",
      "sogne.no",
      "s\u00f8gne.no",
      "xn--sgne-gra.no",
      "somna.no",
      "s\u00f8mna.no",
      "xn--smna-gra.no",
      "sondre-land.no",
      "s\u00f8ndre-land.no",
      "xn--sndre-land-0cb.no",
      "sor-aurdal.no",
      "s\u00f8r-aurdal.no",
      "xn--sr-aurdal-l8a.no",
      "sor-fron.no",
      "s\u00f8r-fron.no",
      "xn--sr-fron-q1a.no",
      "sor-odal.no",
      "s\u00f8r-odal.no",
      "xn--sr-odal-q1a.no",
      "sor-varanger.no",
      "s\u00f8r-varanger.no",
      "xn--sr-varanger-ggb.no",
      "matta-varjjat.no",
      "m\u00e1tta-v\u00e1rjjat.no",
      "xn--mtta-vrjjat-k7af.no",
      "sorfold.no",
      "s\u00f8rfold.no",
      "xn--srfold-bya.no",
      "sorreisa.no",
      "s\u00f8rreisa.no",
      "xn--srreisa-q1a.no",
      "sorum.no",
      "s\u00f8rum.no",
      "xn--srum-gra.no",
      "tana.no",
      "deatnu.no",
      "time.no",
      "tingvoll.no",
      "tinn.no",
      "tjeldsund.no",
      "dielddanuorri.no",
      "tjome.no",
      "tj\u00f8me.no",
      "xn--tjme-hra.no",
      "tokke.no",
      "tolga.no",
      "torsken.no",
      "tranoy.no",
      "tran\u00f8y.no",
      "xn--trany-yua.no",
      "tromso.no",
      "troms\u00f8.no",
      "xn--troms-zua.no",
      "tromsa.no",
      "romsa.no",
      "trondheim.no",
      "troandin.no",
      "trysil.no",
      "trana.no",
      "tr\u00e6na.no",
      "xn--trna-woa.no",
      "trogstad.no",
      "tr\u00f8gstad.no",
      "xn--trgstad-r1a.no",
      "tvedestrand.no",
      "tydal.no",
      "tynset.no",
      "tysfjord.no",
      "divtasvuodna.no",
      "divttasvuotna.no",
      "tysnes.no",
      "tysvar.no",
      "tysv\u00e6r.no",
      "xn--tysvr-vra.no",
      "tonsberg.no",
      "t\u00f8nsberg.no",
      "xn--tnsberg-q1a.no",
      "ullensaker.no",
      "ullensvang.no",
      "ulvik.no",
      "utsira.no",
      "vadso.no",
      "vads\u00f8.no",
      "xn--vads-jra.no",
      "cahcesuolo.no",
      "\u010d\u00e1hcesuolo.no",
      "xn--hcesuolo-7ya35b.no",
      "vaksdal.no",
      "valle.no",
      "vang.no",
      "vanylven.no",
      "vardo.no",
      "vard\u00f8.no",
      "xn--vard-jra.no",
      "varggat.no",
      "v\u00e1rgg\u00e1t.no",
      "xn--vrggt-xqad.no",
      "vefsn.no",
      "vaapste.no",
      "vega.no",
      "vegarshei.no",
      "veg\u00e5rshei.no",
      "xn--vegrshei-c0a.no",
      "vennesla.no",
      "verdal.no",
      "verran.no",
      "vestby.no",
      "vestnes.no",
      "vestre-slidre.no",
      "vestre-toten.no",
      "vestvagoy.no",
      "vestv\u00e5g\u00f8y.no",
      "xn--vestvgy-ixa6o.no",
      "vevelstad.no",
      "vik.no",
      "vikna.no",
      "vindafjord.no",
      "volda.no",
      "voss.no",
      "varoy.no",
      "v\u00e6r\u00f8y.no",
      "xn--vry-yla5g.no",
      "vagan.no",
      "v\u00e5gan.no",
      "xn--vgan-qoa.no",
      "voagat.no",
      "vagsoy.no",
      "v\u00e5gs\u00f8y.no",
      "xn--vgsy-qoa0j.no",
      "vaga.no",
      "v\u00e5g\u00e5.no",
      "xn--vg-yiab.no",
      "valer.ostfold.no",
      "v\u00e5ler.\u00f8stfold.no",
      "xn--vler-qoa.xn--stfold-9xa.no",
      "valer.hedmark.no",
      "v\u00e5ler.hedmark.no",
      "xn--vler-qoa.hedmark.no",
      "nr",
      "biz.nr",
      "info.nr",
      "gov.nr",
      "edu.nr",
      "org.nr",
      "net.nr",
      "com.nr",
      "nu",
      "org",
      "ae.org",
      "za.org",
      "pa",
      "ac.pa",
      "gob.pa",
      "com.pa",
      "org.pa",
      "sld.pa",
      "edu.pa",
      "net.pa",
      "ing.pa",
      "abo.pa",
      "med.pa",
      "nom.pa",
      "pe",
      "edu.pe",
      "gob.pe",
      "nom.pe",
      "mil.pe",
      "org.pe",
      "com.pe",
      "net.pe",
      "pf",
      "com.pf",
      "org.pf",
      "edu.pf",
      "ph",
      "com.ph",
      "net.ph",
      "org.ph",
      "gov.ph",
      "edu.ph",
      "ngo.ph",
      "mil.ph",
      "i.ph",
      "pk",
      "com.pk",
      "net.pk",
      "edu.pk",
      "org.pk",
      "fam.pk",
      "biz.pk",
      "web.pk",
      "gov.pk",
      "gob.pk",
      "gok.pk",
      "gon.pk",
      "gop.pk",
      "gos.pk",
      "info.pk",
      "pl",
      "aid.pl",
      "agro.pl",
      "atm.pl",
      "auto.pl",
      "biz.pl",
      "com.pl",
      "edu.pl",
      "gmina.pl",
      "gsm.pl",
      "info.pl",
      "mail.pl",
      "miasta.pl",
      "media.pl",
      "mil.pl",
      "net.pl",
      "nieruchomosci.pl",
      "nom.pl",
      "org.pl",
      "pc.pl",
      "powiat.pl",
      "priv.pl",
      "realestate.pl",
      "rel.pl",
      "sex.pl",
      "shop.pl",
      "sklep.pl",
      "sos.pl",
      "szkola.pl",
      "targi.pl",
      "tm.pl",
      "tourism.pl",
      "travel.pl",
      "turystyka.pl",
      "6bone.pl",
      "art.pl",
      "mbone.pl",
      "gov.pl",
      "uw.gov.pl",
      "um.gov.pl",
      "ug.gov.pl",
      "upow.gov.pl",
      "starostwo.gov.pl",
      "so.gov.pl",
      "sr.gov.pl",
      "po.gov.pl",
      "pa.gov.pl",
      "ngo.pl",
      "irc.pl",
      "usenet.pl",
      "augustow.pl",
      "babia-gora.pl",
      "bedzin.pl",
      "beskidy.pl",
      "bialowieza.pl",
      "bialystok.pl",
      "bielawa.pl",
      "bieszczady.pl",
      "boleslawiec.pl",
      "bydgoszcz.pl",
      "bytom.pl",
      "cieszyn.pl",
      "czeladz.pl",
      "czest.pl",
      "dlugoleka.pl",
      "elblag.pl",
      "elk.pl",
      "glogow.pl",
      "gniezno.pl",
      "gorlice.pl",
      "grajewo.pl",
      "ilawa.pl",
      "jaworzno.pl",
      "jelenia-gora.pl",
      "jgora.pl",
      "kalisz.pl",
      "kazimierz-dolny.pl",
      "karpacz.pl",
      "kartuzy.pl",
      "kaszuby.pl",
      "katowice.pl",
      "kepno.pl",
      "ketrzyn.pl",
      "klodzko.pl",
      "kobierzyce.pl",
      "kolobrzeg.pl",
      "konin.pl",
      "konskowola.pl",
      "kutno.pl",
      "lapy.pl",
      "lebork.pl",
      "legnica.pl",
      "lezajsk.pl",
      "limanowa.pl",
      "lomza.pl",
      "lowicz.pl",
      "lubin.pl",
      "lukow.pl",
      "malbork.pl",
      "malopolska.pl",
      "mazowsze.pl",
      "mazury.pl",
      "mielec.pl",
      "mielno.pl",
      "mragowo.pl",
      "naklo.pl",
      "nowaruda.pl",
      "nysa.pl",
      "olawa.pl",
      "olecko.pl",
      "olkusz.pl",
      "olsztyn.pl",
      "opoczno.pl",
      "opole.pl",
      "ostroda.pl",
      "ostroleka.pl",
      "ostrowiec.pl",
      "ostrowwlkp.pl",
      "pila.pl",
      "pisz.pl",
      "podhale.pl",
      "podlasie.pl",
      "polkowice.pl",
      "pomorze.pl",
      "pomorskie.pl",
      "prochowice.pl",
      "pruszkow.pl",
      "przeworsk.pl",
      "pulawy.pl",
      "radom.pl",
      "rawa-maz.pl",
      "rybnik.pl",
      "rzeszow.pl",
      "sanok.pl",
      "sejny.pl",
      "siedlce.pl",
      "slask.pl",
      "slupsk.pl",
      "sosnowiec.pl",
      "stalowa-wola.pl",
      "skoczow.pl",
      "starachowice.pl",
      "stargard.pl",
      "suwalki.pl",
      "swidnica.pl",
      "swiebodzin.pl",
      "swinoujscie.pl",
      "szczecin.pl",
      "szczytno.pl",
      "tarnobrzeg.pl",
      "tgory.pl",
      "turek.pl",
      "tychy.pl",
      "ustka.pl",
      "walbrzych.pl",
      "warmia.pl",
      "warszawa.pl",
      "waw.pl",
      "wegrow.pl",
      "wielun.pl",
      "wlocl.pl",
      "wloclawek.pl",
      "wodzislaw.pl",
      "wolomin.pl",
      "wroclaw.pl",
      "zachpomor.pl",
      "zagan.pl",
      "zarow.pl",
      "zgora.pl",
      "zgorzelec.pl",
      "gda.pl",
      "gdansk.pl",
      "gdynia.pl",
      "med.pl",
      "sopot.pl",
      "gliwice.pl",
      "krakow.pl",
      "poznan.pl",
      "wroc.pl",
      "zakopane.pl",
      "co.pl",
      "pn",
      "gov.pn",
      "co.pn",
      "org.pn",
      "edu.pn",
      "net.pn",
      "pr",
      "com.pr",
      "net.pr",
      "org.pr",
      "gov.pr",
      "edu.pr",
      "isla.pr",
      "pro.pr",
      "biz.pr",
      "info.pr",
      "name.pr",
      "est.pr",
      "prof.pr",
      "ac.pr",
      "pro",
      "aca.pro",
      "bar.pro",
      "cpa.pro",
      "jur.pro",
      "law.pro",
      "med.pro",
      "eng.pro",
      "ps",
      "edu.ps",
      "gov.ps",
      "sec.ps",
      "plo.ps",
      "com.ps",
      "org.ps",
      "net.ps",
      "pt",
      "net.pt",
      "gov.pt",
      "org.pt",
      "edu.pt",
      "int.pt",
      "publ.pt",
      "com.pt",
      "nome.pt",
      "pw",
      "co.pw",
      "ne.pw",
      "or.pw",
      "ed.pw",
      "go.pw",
      "belau.pw",
      "re",
      "com.re",
      "asso.re",
      "nom.re",
      "ro",
      "com.ro",
      "org.ro",
      "tm.ro",
      "nt.ro",
      "nom.ro",
      "info.ro",
      "rec.ro",
      "arts.ro",
      "firm.ro",
      "store.ro",
      "www.ro",
      "rs",
      "co.rs",
      "org.rs",
      "edu.rs",
      "ac.rs",
      "gov.rs",
      "in.rs",
      "ru",
      "ac.ru",
      "com.ru",
      "edu.ru",
      "int.ru",
      "net.ru",
      "org.ru",
      "pp.ru",
      "adygeya.ru",
      "altai.ru",
      "amur.ru",
      "arkhangelsk.ru",
      "astrakhan.ru",
      "bashkiria.ru",
      "belgorod.ru",
      "bir.ru",
      "bryansk.ru",
      "buryatia.ru",
      "cbg.ru",
      "chel.ru",
      "chelyabinsk.ru",
      "chita.ru",
      "chukotka.ru",
      "chuvashia.ru",
      "dagestan.ru",
      "dudinka.ru",
      "e-burg.ru",
      "grozny.ru",
      "irkutsk.ru",
      "ivanovo.ru",
      "izhevsk.ru",
      "jar.ru",
      "joshkar-ola.ru",
      "kalmykia.ru",
      "kaluga.ru",
      "kamchatka.ru",
      "karelia.ru",
      "kazan.ru",
      "kchr.ru",
      "kemerovo.ru",
      "khabarovsk.ru",
      "khakassia.ru",
      "khv.ru",
      "kirov.ru",
      "koenig.ru",
      "komi.ru",
      "kostroma.ru",
      "krasnoyarsk.ru",
      "kuban.ru",
      "kurgan.ru",
      "kursk.ru",
      "lipetsk.ru",
      "magadan.ru",
      "mari.ru",
      "mari-el.ru",
      "marine.ru",
      "mordovia.ru",
      "mosreg.ru",
      "msk.ru",
      "murmansk.ru",
      "nalchik.ru",
      "nnov.ru",
      "nov.ru",
      "novosibirsk.ru",
      "nsk.ru",
      "omsk.ru",
      "orenburg.ru",
      "oryol.ru",
      "palana.ru",
      "penza.ru",
      "perm.ru",
      "pskov.ru",
      "ptz.ru",
      "rnd.ru",
      "ryazan.ru",
      "sakhalin.ru",
      "samara.ru",
      "saratov.ru",
      "simbirsk.ru",
      "smolensk.ru",
      "spb.ru",
      "stavropol.ru",
      "stv.ru",
      "surgut.ru",
      "tambov.ru",
      "tatarstan.ru",
      "tom.ru",
      "tomsk.ru",
      "tsaritsyn.ru",
      "tsk.ru",
      "tula.ru",
      "tuva.ru",
      "tver.ru",
      "tyumen.ru",
      "udm.ru",
      "udmurtia.ru",
      "ulan-ude.ru",
      "vladikavkaz.ru",
      "vladimir.ru",
      "vladivostok.ru",
      "volgograd.ru",
      "vologda.ru",
      "voronezh.ru",
      "vrn.ru",
      "vyatka.ru",
      "yakutia.ru",
      "yamal.ru",
      "yaroslavl.ru",
      "yekaterinburg.ru",
      "yuzhno-sakhalinsk.ru",
      "amursk.ru",
      "baikal.ru",
      "cmw.ru",
      "fareast.ru",
      "jamal.ru",
      "kms.ru",
      "k-uralsk.ru",
      "kustanai.ru",
      "kuzbass.ru",
      "magnitka.ru",
      "mytis.ru",
      "nakhodka.ru",
      "nkz.ru",
      "norilsk.ru",
      "oskol.ru",
      "pyatigorsk.ru",
      "rubtsovsk.ru",
      "snz.ru",
      "syzran.ru",
      "vdonsk.ru",
      "zgrad.ru",
      "gov.ru",
      "mil.ru",
      "test.ru",
      "rw",
      "gov.rw",
      "net.rw",
      "edu.rw",
      "ac.rw",
      "com.rw",
      "co.rw",
      "int.rw",
      "mil.rw",
      "gouv.rw",
      "sa",
      "com.sa",
      "net.sa",
      "org.sa",
      "gov.sa",
      "med.sa",
      "pub.sa",
      "edu.sa",
      "sch.sa",
      "sb",
      "com.sb",
      "edu.sb",
      "gov.sb",
      "net.sb",
      "org.sb",
      "sc",
      "com.sc",
      "gov.sc",
      "net.sc",
      "org.sc",
      "edu.sc",
      "sd",
      "com.sd",
      "net.sd",
      "org.sd",
      "edu.sd",
      "med.sd",
      "gov.sd",
      "info.sd",
      "se",
      "a.se",
      "ac.se",
      "b.se",
      "bd.se",
      "brand.se",
      "c.se",
      "d.se",
      "e.se",
      "f.se",
      "fh.se",
      "fhsk.se",
      "fhv.se",
      "g.se",
      "h.se",
      "i.se",
      "k.se",
      "komforb.se",
      "kommunalforbund.se",
      "komvux.se",
      "l.se",
      "lanbib.se",
      "m.se",
      "n.se",
      "naturbruksgymn.se",
      "o.se",
      "org.se",
      "p.se",
      "parti.se",
      "pp.se",
      "press.se",
      "r.se",
      "s.se",
      "sshn.se",
      "t.se",
      "tm.se",
      "u.se",
      "w.se",
      "x.se",
      "y.se",
      "z.se",
      "sg",
      "com.sg",
      "net.sg",
      "org.sg",
      "gov.sg",
      "edu.sg",
      "per.sg",
      "sh",
      "si",
      "sk",
      "sl",
      "com.sl",
      "net.sl",
      "edu.sl",
      "gov.sl",
      "org.sl",
      "sm",
      "sn",
      "art.sn",
      "com.sn",
      "edu.sn",
      "gouv.sn",
      "org.sn",
      "perso.sn",
      "univ.sn",
      "so",
      "com.so",
      "net.so",
      "org.so",
      "sr",
      "st",
      "co.st",
      "com.st",
      "consulado.st",
      "edu.st",
      "embaixada.st",
      "gov.st",
      "mil.st",
      "net.st",
      "org.st",
      "principe.st",
      "saotome.st",
      "store.st",
      "su",
      "sy",
      "edu.sy",
      "gov.sy",
      "net.sy",
      "mil.sy",
      "com.sy",
      "org.sy",
      "sz",
      "co.sz",
      "ac.sz",
      "org.sz",
      "tc",
      "td",
      "tel",
      "tf",
      "tg",
      "th",
      "ac.th",
      "co.th",
      "go.th",
      "in.th",
      "mi.th",
      "net.th",
      "or.th",
      "tj",
      "ac.tj",
      "biz.tj",
      "co.tj",
      "com.tj",
      "edu.tj",
      "go.tj",
      "gov.tj",
      "int.tj",
      "mil.tj",
      "name.tj",
      "net.tj",
      "nic.tj",
      "org.tj",
      "test.tj",
      "web.tj",
      "tk",
      "tl",
      "gov.tl",
      "tm",
      "tn",
      "com.tn",
      "ens.tn",
      "fin.tn",
      "gov.tn",
      "ind.tn",
      "intl.tn",
      "nat.tn",
      "net.tn",
      "org.tn",
      "info.tn",
      "perso.tn",
      "tourism.tn",
      "edunet.tn",
      "rnrt.tn",
      "rns.tn",
      "rnu.tn",
      "mincom.tn",
      "agrinet.tn",
      "defense.tn",
      "turen.tn",
      "to",
      "com.to",
      "gov.to",
      "net.to",
      "org.to",
      "edu.to",
      "mil.to",
      "gov.nc.tr",
      "travel",
      "tt",
      "co.tt",
      "com.tt",
      "org.tt",
      "net.tt",
      "biz.tt",
      "info.tt",
      "pro.tt",
      "int.tt",
      "coop.tt",
      "jobs.tt",
      "mobi.tt",
      "travel.tt",
      "museum.tt",
      "aero.tt",
      "name.tt",
      "gov.tt",
      "edu.tt",
      "tv",
      "tw",
      "edu.tw",
      "gov.tw",
      "mil.tw",
      "com.tw",
      "net.tw",
      "org.tw",
      "idv.tw",
      "game.tw",
      "ebiz.tw",
      "club.tw",
      "\u7db2\u8def.tw",
      "xn--zf0ao64a.tw",
      "\u7d44\u7e54.tw",
      "xn--uc0atv.tw",
      "\u5546\u696d.tw",
      "xn--czrw28b.tw",
      "ac.tz",
      "co.tz",
      "go.tz",
      "mil.tz",
      "ne.tz",
      "or.tz",
      "sc.tz",
      "ua",
      "com.ua",
      "edu.ua",
      "gov.ua",
      "in.ua",
      "net.ua",
      "org.ua",
      "cherkassy.ua",
      "chernigov.ua",
      "chernovtsy.ua",
      "ck.ua",
      "cn.ua",
      "crimea.ua",
      "cv.ua",
      "dn.ua",
      "dnepropetrovsk.ua",
      "donetsk.ua",
      "dp.ua",
      "if.ua",
      "ivano-frankivsk.ua",
      "kh.ua",
      "kharkov.ua",
      "kherson.ua",
      "khmelnitskiy.ua",
      "kiev.ua",
      "kirovograd.ua",
      "km.ua",
      "kr.ua",
      "ks.ua",
      "kv.ua",
      "lg.ua",
      "lugansk.ua",
      "lutsk.ua",
      "lviv.ua",
      "mk.ua",
      "nikolaev.ua",
      "od.ua",
      "odessa.ua",
      "pl.ua",
      "poltava.ua",
      "rovno.ua",
      "rv.ua",
      "sebastopol.ua",
      "sumy.ua",
      "te.ua",
      "ternopil.ua",
      "uzhgorod.ua",
      "vinnica.ua",
      "vn.ua",
      "zaporizhzhe.ua",
      "zp.ua",
      "zhitomir.ua",
      "zt.ua",
      "ug",
      "co.ug",
      "ac.ug",
      "sc.ug",
      "go.ug",
      "ne.ug",
      "or.ug",
      "us",
      "dni.us",
      "fed.us",
      "isa.us",
      "kids.us",
      "nsn.us",
      "ak.us",
      "al.us",
      "ar.us",
      "as.us",
      "az.us",
      "ca.us",
      "co.us",
      "ct.us",
      "dc.us",
      "de.us",
      "fl.us",
      "ga.us",
      "gu.us",
      "hi.us",
      "ia.us",
      "id.us",
      "il.us",
      "in.us",
      "ks.us",
      "ky.us",
      "la.us",
      "ma.us",
      "md.us",
      "me.us",
      "mi.us",
      "mn.us",
      "mo.us",
      "ms.us",
      "mt.us",
      "nc.us",
      "nd.us",
      "ne.us",
      "nh.us",
      "nj.us",
      "nm.us",
      "nv.us",
      "ny.us",
      "oh.us",
      "ok.us",
      "or.us",
      "pa.us",
      "pr.us",
      "ri.us",
      "sc.us",
      "sd.us",
      "tn.us",
      "tx.us",
      "ut.us",
      "vi.us",
      "vt.us",
      "va.us",
      "wa.us",
      "wi.us",
      "wv.us",
      "wy.us",
      "k12.ak.us",
      "k12.al.us",
      "k12.ar.us",
      "k12.as.us",
      "k12.az.us",
      "k12.ca.us",
      "k12.co.us",
      "k12.ct.us",
      "k12.dc.us",
      "k12.de.us",
      "k12.fl.us",
      "k12.ga.us",
      "k12.gu.us",
      "k12.ia.us",
      "k12.id.us",
      "k12.il.us",
      "k12.in.us",
      "k12.ks.us",
      "k12.ky.us",
      "k12.la.us",
      "k12.ma.us",
      "k12.md.us",
      "k12.me.us",
      "k12.mi.us",
      "k12.mn.us",
      "k12.mo.us",
      "k12.ms.us",
      "k12.mt.us",
      "k12.nc.us",
      "k12.nd.us",
      "k12.ne.us",
      "k12.nh.us",
      "k12.nj.us",
      "k12.nm.us",
      "k12.nv.us",
      "k12.ny.us",
      "k12.oh.us",
      "k12.ok.us",
      "k12.or.us",
      "k12.pa.us",
      "k12.pr.us",
      "k12.ri.us",
      "k12.sc.us",
      "k12.sd.us",
      "k12.tn.us",
      "k12.tx.us",
      "k12.ut.us",
      "k12.vi.us",
      "k12.vt.us",
      "k12.va.us",
      "k12.wa.us",
      "k12.wi.us",
      "k12.wv.us",
      "k12.wy.us",
      "cc.ak.us",
      "cc.al.us",
      "cc.ar.us",
      "cc.as.us",
      "cc.az.us",
      "cc.ca.us",
      "cc.co.us",
      "cc.ct.us",
      "cc.dc.us",
      "cc.de.us",
      "cc.fl.us",
      "cc.ga.us",
      "cc.gu.us",
      "cc.hi.us",
      "cc.ia.us",
      "cc.id.us",
      "cc.il.us",
      "cc.in.us",
      "cc.ks.us",
      "cc.ky.us",
      "cc.la.us",
      "cc.ma.us",
      "cc.md.us",
      "cc.me.us",
      "cc.mi.us",
      "cc.mn.us",
      "cc.mo.us",
      "cc.ms.us",
      "cc.mt.us",
      "cc.nc.us",
      "cc.nd.us",
      "cc.ne.us",
      "cc.nh.us",
      "cc.nj.us",
      "cc.nm.us",
      "cc.nv.us",
      "cc.ny.us",
      "cc.oh.us",
      "cc.ok.us",
      "cc.or.us",
      "cc.pa.us",
      "cc.pr.us",
      "cc.ri.us",
      "cc.sc.us",
      "cc.sd.us",
      "cc.tn.us",
      "cc.tx.us",
      "cc.ut.us",
      "cc.vi.us",
      "cc.vt.us",
      "cc.va.us",
      "cc.wa.us",
      "cc.wi.us",
      "cc.wv.us",
      "cc.wy.us",
      "lib.ak.us",
      "lib.al.us",
      "lib.ar.us",
      "lib.as.us",
      "lib.az.us",
      "lib.ca.us",
      "lib.co.us",
      "lib.ct.us",
      "lib.dc.us",
      "lib.de.us",
      "lib.fl.us",
      "lib.ga.us",
      "lib.gu.us",
      "lib.hi.us",
      "lib.ia.us",
      "lib.id.us",
      "lib.il.us",
      "lib.in.us",
      "lib.ks.us",
      "lib.ky.us",
      "lib.la.us",
      "lib.ma.us",
      "lib.md.us",
      "lib.me.us",
      "lib.mi.us",
      "lib.mn.us",
      "lib.mo.us",
      "lib.ms.us",
      "lib.mt.us",
      "lib.nc.us",
      "lib.nd.us",
      "lib.ne.us",
      "lib.nh.us",
      "lib.nj.us",
      "lib.nm.us",
      "lib.nv.us",
      "lib.ny.us",
      "lib.oh.us",
      "lib.ok.us",
      "lib.or.us",
      "lib.pa.us",
      "lib.pr.us",
      "lib.ri.us",
      "lib.sc.us",
      "lib.sd.us",
      "lib.tn.us",
      "lib.tx.us",
      "lib.ut.us",
      "lib.vi.us",
      "lib.vt.us",
      "lib.va.us",
      "lib.wa.us",
      "lib.wi.us",
      "lib.wv.us",
      "lib.wy.us",
      "pvt.k12.ma.us",
      "chtr.k12.ma.us",
      "paroch.k12.ma.us",
      "uz",
      "com.uz",
      "co.uz",
      "va",
      "vc",
      "com.vc",
      "net.vc",
      "org.vc",
      "gov.vc",
      "mil.vc",
      "edu.vc",
      "vg",
      "vi",
      "co.vi",
      "com.vi",
      "k12.vi",
      "net.vi",
      "org.vi",
      "vn",
      "com.vn",
      "net.vn",
      "org.vn",
      "edu.vn",
      "gov.vn",
      "int.vn",
      "ac.vn",
      "biz.vn",
      "info.vn",
      "name.vn",
      "pro.vn",
      "health.vn",
      "vu",
      "ws",
      "com.ws",
      "net.ws",
      "org.ws",
      "gov.ws",
      "edu.ws",
      "\u0627\u0645\u0627\u0631\u0627\u062a",
      "xn--mgbaam7a8h",
      "\u09ac\u09be\u0982\u09b2\u09be",
      "xn--54b7fta0cc",
      "\u4e2d\u56fd",
      "xn--fiqs8s",
      "\u4e2d\u570b",
      "xn--fiqz9s",
      "\u0627\u0644\u062c\u0632\u0627\u0626\u0631",
      "xn--lgbbat1ad8j",
      "\u0645\u0635\u0631",
      "xn--wgbh1c",
      "\u10d2\u10d4",
      "xn--node",
      "\u9999\u6e2f",
      "xn--j6w193g",
      "\u092d\u093e\u0930\u0924",
      "xn--h2brj9c",
      "\u0628\u06be\u0627\u0631\u062a",
      "xn--mgbbh1a71e",
      "\u0c2d\u0c3e\u0c30\u0c24\u0c4d",
      "xn--fpcrj9c3d",
      "\u0aad\u0abe\u0ab0\u0aa4",
      "xn--gecrj9c",
      "\u0a2d\u0a3e\u0a30\u0a24",
      "xn--s9brj9c",
      "\u09ad\u09be\u09b0\u09a4",
      "xn--45brj9c",
      "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe",
      "xn--xkc2dl3a5ee0h",
      "\u0627\u06cc\u0631\u0627\u0646",
      "xn--mgba3a4f16a",
      "\u0627\u064a\u0631\u0627\u0646",
      "xn--mgba3a4fra",
      "\u0627\u0644\u0627\u0631\u062f\u0646",
      "xn--mgbayh7gpa",
      "\ud55c\uad6d",
      "xn--3e0b707e",
      "\u0dbd\u0d82\u0d9a\u0dcf",
      "xn--fzc2c9e2c",
      "\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8",
      "xn--xkc2al3hye2a",
      "\u0627\u0644\u0645\u063a\u0631\u0628",
      "xn--mgbc0a9azcg",
      "\u0639\u0645\u0627\u0646",
      "xn--mgb9awbf",
      "\u0641\u0644\u0633\u0637\u064a\u0646",
      "xn--ygbi2ammx",
      "\u0441\u0440\u0431",
      "xn--90a3ac",
      "\u0440\u0444",
      "xn--p1ai",
      "\u0642\u0637\u0631",
      "xn--wgbl6a",
      "\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629",
      "xn--mgberp4a5d4ar",
      "\u0627\u0644\u0633\u0639\u0648\u062f\u06cc\u0629",
      "xn--mgberp4a5d4a87g",
      "\u0627\u0644\u0633\u0639\u0648\u062f\u06cc\u06c3",
      "xn--mgbqly7c0a67fbc",
      "\u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0647",
      "xn--mgbqly7cvafr",
      "\u0633\u0648\u0631\u064a\u0629",
      "xn--ogbpf8fl",
      "\u0633\u0648\u0631\u064a\u0627",
      "xn--mgbtf8fl",
      "\u65b0\u52a0\u5761",
      "xn--yfro4i67o",
      "\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd",
      "xn--clchc0ea0b2g2a9gcd",
      "\u0e44\u0e17\u0e22",
      "xn--o3cw4h",
      "\u062a\u0648\u0646\u0633",
      "xn--pgbs0dh",
      "\u53f0\u7063",
      "xn--kpry57d",
      "\u53f0\u6e7e",
      "xn--kprw13d",
      "\u81fa\u7063",
      "xn--nnx388a",
      "\u0443\u043a\u0440",
      "xn--j1amh",
      "\u0627\u0644\u064a\u0645\u0646",
      "xn--mgb2ddes",
      "xxx",
      "tp",
      "yt",
      "ng"
  );

  /**
   * If a hostname is not in the EXCLUDE set, and if removing its
   * leftmost component results in a name which is contained in this
   * set, it is a TLD.
   */
  static final Set<String> UNDER = ImmutableSet.of(
      "ar",
      "au",
      "bd",
      "bn",
      "ck",
      "cy",
      "er",
      "et",
      "fj",
      "fk",
      "gt",
      "gu",
      "il",
      "jm",
      "aichi.jp",
      "akita.jp",
      "aomori.jp",
      "chiba.jp",
      "ehime.jp",
      "fukui.jp",
      "fukuoka.jp",
      "fukushima.jp",
      "gifu.jp",
      "gunma.jp",
      "hiroshima.jp",
      "hokkaido.jp",
      "hyogo.jp",
      "ibaraki.jp",
      "ishikawa.jp",
      "iwate.jp",
      "kagawa.jp",
      "kagoshima.jp",
      "kanagawa.jp",
      "kawasaki.jp",
      "kitakyushu.jp",
      "kobe.jp",
      "kochi.jp",
      "kumamoto.jp",
      "kyoto.jp",
      "mie.jp",
      "miyagi.jp",
      "miyazaki.jp",
      "nagano.jp",
      "nagasaki.jp",
      "nagoya.jp",
      "nara.jp",
      "niigata.jp",
      "oita.jp",
      "okayama.jp",
      "okinawa.jp",
      "osaka.jp",
      "saga.jp",
      "saitama.jp",
      "sapporo.jp",
      "sendai.jp",
      "shiga.jp",
      "shimane.jp",
      "shizuoka.jp",
      "tochigi.jp",
      "tokushima.jp",
      "tokyo.jp",
      "tottori.jp",
      "toyama.jp",
      "wakayama.jp",
      "yamagata.jp",
      "yamaguchi.jp",
      "yamanashi.jp",
      "yokohama.jp",
      "ke",
      "kh",
      "kw",
      "mm",
      "mt",
      "mz",
      "ni",
      "np",
      "nz",
      "om",
      "pg",
      "py",
      "qa",
      "sv",
      "tr",
      "uk",
      "sch.uk",
      "uy",
      "ve",
      "ye",
      "yu",
      "za",
      "zm",
      "zw"
  );

  /**
   * The elements in this set would pass the UNDER test, but are
   * known not to be TLDs and are thus excluded from consideration.
   */
  static final Set<String> EXCLUDED = ImmutableSet.of(
      "congresodelalengua3.ar",
      "educ.ar",
      "gobiernoelectronico.ar",
      "mecon.ar",
      "nacion.ar",
      "nic.ar",
      "promocion.ar",
      "retina.ar",
      "uba.ar",
      "metro.tokyo.jp",
      "pref.aichi.jp",
      "pref.akita.jp",
      "pref.aomori.jp",
      "pref.chiba.jp",
      "pref.ehime.jp",
      "pref.fukui.jp",
      "pref.fukuoka.jp",
      "pref.fukushima.jp",
      "pref.gifu.jp",
      "pref.gunma.jp",
      "pref.hiroshima.jp",
      "pref.hokkaido.jp",
      "pref.hyogo.jp",
      "pref.ibaraki.jp",
      "pref.ishikawa.jp",
      "pref.iwate.jp",
      "pref.kagawa.jp",
      "pref.kagoshima.jp",
      "pref.kanagawa.jp",
      "pref.kochi.jp",
      "pref.kumamoto.jp",
      "pref.kyoto.jp",
      "pref.mie.jp",
      "pref.miyagi.jp",
      "pref.miyazaki.jp",
      "pref.nagano.jp",
      "pref.nagasaki.jp",
      "pref.nara.jp",
      "pref.niigata.jp",
      "pref.oita.jp",
      "pref.okayama.jp",
      "pref.okinawa.jp",
      "pref.osaka.jp",
      "pref.saga.jp",
      "pref.saitama.jp",
      "pref.shiga.jp",
      "pref.shimane.jp",
      "pref.shizuoka.jp",
      "pref.tochigi.jp",
      "pref.tokushima.jp",
      "pref.tottori.jp",
      "pref.toyama.jp",
      "pref.wakayama.jp",
      "pref.yamagata.jp",
      "pref.yamaguchi.jp",
      "pref.yamanashi.jp",
      "city.chiba.jp",
      "city.fukuoka.jp",
      "city.hiroshima.jp",
      "city.kawasaki.jp",
      "city.kitakyushu.jp",
      "city.kobe.jp",
      "city.kyoto.jp",
      "city.nagoya.jp",
      "city.niigata.jp",
      "city.okayama.jp",
      "city.osaka.jp",
      "city.saitama.jp",
      "city.sapporo.jp",
      "city.sendai.jp",
      "city.shizuoka.jp",
      "city.yokohama.jp",
      "mediaphone.om",
      "nawrastelecom.om",
      "nawras.om",
      "omanmobile.om",
      "omanpost.om",
      "omantel.om",
      "rakpetroleum.om",
      "siemens.om",
      "songfest.om",
      "statecouncil.om",
      "nic.tr",
      "tsk.tr",
      "bl.uk",
      "british-library.uk",
      "icnet.uk",
      "jet.uk",
      "nel.uk",
      "nhs.uk",
      "nls.uk",
      "national-library-scotland.uk",
      "parliament.uk",
      "police.uk"
  );
}

