/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.sidenav.ExperimentalFeatureException;
import com.vaadin.flow.component.sidenav.SideNavItemContainer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinContext;

@Tag(value="vaadin-side-nav")
@NpmPackage(value="@vaadin/side-nav", version="24.1.9")
@JsModule(value="@vaadin/side-nav/src/vaadin-side-nav.js")
public class SideNav
extends SideNavItemContainer
implements HasSize,
HasStyle {
    private Element labelElement;

    public SideNav() {
    }

    public SideNav(String label) {
        this.setLabel(label);
    }

    public String getLabel() {
        return this.labelElement == null ? null : this.labelElement.getText();
    }

    public void setLabel(String label) {
        if (label == null) {
            this.removeLabelElement();
        } else {
            if (this.labelElement == null) {
                this.labelElement = this.createAndAppendLabelElement();
            }
            this.labelElement.setText(label);
        }
    }

    private Element createAndAppendLabelElement() {
        Element element = new Element("span");
        element.setAttribute("slot", "label");
        this.getElement().appendChild(new Element[]{element});
        return element;
    }

    private void removeLabelElement() {
        if (this.labelElement != null) {
            this.getElement().removeChild(new Element[]{this.labelElement});
            this.labelElement = null;
        }
    }

    public boolean isCollapsible() {
        return this.getElement().getProperty("collapsible", false);
    }

    public void setCollapsible(boolean collapsible) {
        this.getElement().setProperty("collapsible", collapsible);
    }

    @Synchronize(property="collapsed", value={"collapsed-changed"})
    public boolean isExpanded() {
        return !this.getElement().getProperty("collapsed", false);
    }

    public void setExpanded(boolean expanded) {
        this.getElement().setProperty("collapsed", !expanded);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.checkFeatureFlag();
    }

    private void checkFeatureFlag() {
        boolean enabled = this.getFeatureFlags().isEnabled(FeatureFlags.SIDE_NAV_COMPONENT);
        if (!enabled) {
            throw new ExperimentalFeatureException();
        }
    }

    protected FeatureFlags getFeatureFlags() {
        return FeatureFlags.get((VaadinContext)UI.getCurrent().getSession().getService().getContext());
    }
}

