/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.tabs;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.tabs.GeneratedVaadinTabs;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public class Tabs
extends GeneratedVaadinTabs<Tabs>
implements HasOrderedComponents<Tabs>,
HasSize {
    private static final String SELECTED = "selected";
    private transient Tab selectedTab;

    public Tabs() {
        this.getElement().addPropertyChangeListener(SELECTED, (PropertyChangeListener & Serializable)event -> this.updateSelectedTab());
    }

    public Tabs(Tab ... tabs) {
        this();
        this.add(tabs);
    }

    public void add(Tab ... tabs) {
        super.add((Component[])tabs);
    }

    public Registration addSelectedChangeListener(ComponentEventListener<SelectedChangeEvent> listener) {
        return this.addListener(SelectedChangeEvent.class, listener);
    }

    @Synchronize(property="selected", value={"selected-changed"})
    public int getSelectedIndex() {
        return this.getElement().getProperty(SELECTED, 0);
    }

    public void setSelectedIndex(int selectedIndex) {
        this.getElement().setProperty(SELECTED, (double)selectedIndex);
    }

    public Tab getSelectedTab() {
        int selectedIndex = this.getSelectedIndex();
        Component selectedComponent = this.getComponentAt(selectedIndex);
        if (!(selectedComponent instanceof Tab)) {
            throw new IllegalStateException("Illegal component inside Tabs: " + selectedComponent);
        }
        return (Tab)selectedComponent;
    }

    public void setSelectedTab(Tab selectedTab) {
        int selectedIndex = this.indexOf(selectedTab);
        if (selectedIndex < 0) {
            throw new IllegalArgumentException("Tab to select must be a child: " + (Object)((Object)selectedTab));
        }
        this.getElement().setProperty(SELECTED, (double)selectedIndex);
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        if (orientation != null) {
            return Orientation.valueOf(orientation.toUpperCase(Locale.ROOT));
        }
        return Orientation.HORIZONTAL;
    }

    public void setOrientation(Orientation orientation) {
        this.getElement().setProperty("orientation", orientation.name().toLowerCase());
    }

    public void setFlexGrowForEnclosedTabs(double flexGrow) {
        if (flexGrow < 0.0) {
            throw new IllegalArgumentException("Flex grow property must not be negative");
        }
        this.getChildren().forEach(tab -> ((Tab)((Object)tab)).setFlexGrow(flexGrow));
    }

    @ClientCallable
    private void itemsChanged() {
        Tab currentlySelected = this.getSelectedTab();
        if (!Objects.equals((Object)currentlySelected, (Object)this.selectedTab)) {
            this.selectedTab = currentlySelected;
        }
    }

    private void updateSelectedTab() {
        Tab selected = this.getSelectedTab();
        if (selected.isEnabled()) {
            this.selectedTab = selected;
            this.getChildren().filter(Tab.class::isInstance).map(Tab.class::cast).forEach(tab -> tab.setSelected(false));
            this.selectedTab.setSelected(true);
        } else {
            this.updateEnabled(selected);
            this.setSelectedTab(this.selectedTab);
        }
    }

    private void updateEnabled(Tab tab) {
        boolean enabled = tab.isEnabled();
        Serializable rawValue = tab.getElement().getPropertyRaw("disabled");
        if (rawValue instanceof Boolean) {
            tab.getElement().setProperty("disabled", enabled ? null : Boolean.TRUE.toString());
        } else {
            tab.setEnabled(enabled);
        }
    }

    @DomEvent(value="selected-changed")
    public static class SelectedChangeEvent
    extends ComponentEvent<Tabs> {
        public SelectedChangeEvent(Tabs source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

