/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.biz.impl;

import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.glue.GlueFactory;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.impl.GlueJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.thread.JobThread;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorBizImpl
implements ExecutorBiz {
    private static Logger logger = LoggerFactory.getLogger(ExecutorBizImpl.class);

    @Override
    public ReturnT<String> beat() {
        return ReturnT.SUCCESS;
    }

    @Override
    public ReturnT<String> kill(int jobId) {
        JobThread jobThread = XxlJobExecutor.loadJobThread(jobId);
        if (jobThread != null) {
            IJobHandler handler = jobThread.getHandler();
            jobThread.toStop("\u4eba\u5de5\u624b\u52a8\u7ec8\u6b62");
            jobThread.interrupt();
            XxlJobExecutor.removeJobThread(jobId);
            return ReturnT.SUCCESS;
        }
        return new ReturnT<String>(200, "job thread aleady killed.");
    }

    @Override
    public ReturnT<String> log(long logDateTim, int logId) {
        String logFileName = XxlJobFileAppender.makeLogFileName(new Date(logDateTim), logId);
        String logConteng = XxlJobFileAppender.readLog(logFileName);
        return new ReturnT<String>(200, logConteng);
    }

    @Override
    public ReturnT<String> run(TriggerParam triggerParam) {
        JobThread jobThread = XxlJobExecutor.loadJobThread(triggerParam.getJobId());
        if (!triggerParam.isGlueSwitch()) {
            IJobHandler jobHandler = XxlJobExecutor.loadJobHandler(triggerParam.getExecutorHandler());
            if (jobHandler == null) {
                return new ReturnT<String>(500, "job handler for JobId=[" + triggerParam.getJobId() + "] not found.");
            }
            if (jobThread != null && jobThread.getHandler() != jobHandler) {
                jobThread.toStop("\u66f4\u6362\u4efb\u52a1\u6a21\u5f0f\u6216JobHandler,\u7ec8\u6b62\u65e7\u4efb\u52a1\u7ebf\u7a0b");
                jobThread.interrupt();
                XxlJobExecutor.removeJobThread(triggerParam.getJobId());
                jobThread = null;
            }
            if (jobThread == null) {
                jobThread = XxlJobExecutor.registJobThread(triggerParam.getJobId(), jobHandler);
            }
        } else {
            if (!GlueFactory.isActive()) {
                return new ReturnT<String>(500, "glueLoader for JobId=[" + triggerParam.getJobId() + "] not found.");
            }
            if (!(jobThread == null || jobThread.getHandler() instanceof GlueJobHandler && ((GlueJobHandler)jobThread.getHandler()).getGlueUpdatetime() == triggerParam.getGlueUpdatetime())) {
                jobThread.toStop("\u66f4\u6362\u4efb\u52a1\u6a21\u5f0f\u6216JobHandler,\u7ec8\u6b62\u65e7\u4efb\u52a1\u7ebf\u7a0b");
                jobThread.interrupt();
                XxlJobExecutor.removeJobThread(triggerParam.getJobId());
                jobThread = null;
            }
            if (jobThread == null) {
                IJobHandler jobHandler = null;
                try {
                    jobHandler = GlueFactory.getInstance().loadNewInstance(triggerParam.getJobId());
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    return new ReturnT<String>(500, e.getMessage());
                }
                jobThread = XxlJobExecutor.registJobThread(triggerParam.getJobId(), new GlueJobHandler(jobHandler, triggerParam.getGlueUpdatetime()));
            }
        }
        jobThread.pushTriggerQueue(triggerParam);
        return ReturnT.SUCCESS;
    }
}

