/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.rpc.netcom;

import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.registry.RegistHelper;
import com.xxl.job.core.rpc.codec.RpcRequest;
import com.xxl.job.core.rpc.codec.RpcResponse;
import com.xxl.job.core.rpc.netcom.jetty.server.JettyServer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.reflect.FastClass;
import org.springframework.cglib.reflect.FastMethod;

public class NetComServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(NetComServerFactory.class);
    JettyServer server = new JettyServer();
    private static Map<String, Object> serviceMap = new HashMap<String, Object>();

    public void start(int port, String ip, String appName, RegistHelper registHelper) throws Exception {
        this.server.start(port, ip, appName, registHelper);
    }

    public void destroy() {
        this.server.destroy();
    }

    public static void putService(Class<?> iface, Object serviceBean) {
        serviceMap.put(iface.getName(), serviceBean);
    }

    public static RpcResponse invokeService(RpcRequest request, Object serviceBean) {
        if (serviceBean == null) {
            serviceBean = serviceMap.get(request.getClassName());
        }
        if (serviceBean == null) {
            // empty if block
        }
        RpcResponse response = new RpcResponse();
        if (System.currentTimeMillis() - request.getCreateMillisTime() > 60000L) {
            response.setResult(new ReturnT(500, "Timestamp Timeout."));
            return response;
        }
        try {
            Class<?> serviceClass = serviceBean.getClass();
            String methodName = request.getMethodName();
            Class[] parameterTypes = request.getParameterTypes();
            Object[] parameters = request.getParameters();
            FastClass serviceFastClass = FastClass.create(serviceClass);
            FastMethod serviceFastMethod = serviceFastClass.getMethod(methodName, parameterTypes);
            Object result = serviceFastMethod.invoke(serviceBean, parameters);
            response.setResult(result);
        }
        catch (Throwable t) {
            t.printStackTrace();
            response.setError(t.getMessage());
        }
        return response;
    }
}

