/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.rpc.netcom.jetty.server;

import com.xxl.job.core.rpc.codec.RpcRequest;
import com.xxl.job.core.rpc.codec.RpcResponse;
import com.xxl.job.core.rpc.netcom.NetComServerFactory;
import com.xxl.job.core.rpc.serialize.HessianSerializer;
import com.xxl.job.core.util.HttpClientUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JettyServerHandler
extends AbstractHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] requestBytes = HttpClientUtil.readBytes(request);
        RpcRequest rpcRequest = (RpcRequest)HessianSerializer.deserialize(requestBytes, RpcRequest.class);
        RpcResponse rpcResponse = NetComServerFactory.invokeService(rpcRequest, null);
        byte[] responseBytes = HessianSerializer.serialize(rpcResponse);
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        baseRequest.setHandled(true);
        ServletOutputStream out = response.getOutputStream();
        out.write(responseBytes);
        out.flush();
    }
}

