/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.rpc.netcom.NetComClientProxy;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerCallbackThread {
    private static Logger logger = LoggerFactory.getLogger(TriggerCallbackThread.class);
    private static TriggerCallbackThread instance = new TriggerCallbackThread();
    private LinkedBlockingQueue<HandleCallbackParam> callBackQueue = new LinkedBlockingQueue();
    private Thread triggerCallbackThread;
    private boolean toStop = false;

    public static TriggerCallbackThread getInstance() {
        return instance;
    }

    public void start() {
        this.triggerCallbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: while (!TriggerCallbackThread.this.toStop) {
                    try {
                        HandleCallbackParam callback = (HandleCallbackParam)TriggerCallbackThread.getInstance().callBackQueue.take();
                        if (callback == null) continue;
                        for (String address : callback.getLogAddress()) {
                            try {
                                AdminBiz adminBiz = (AdminBiz)new NetComClientProxy(AdminBiz.class, address).getObject();
                                ReturnT<String> callbackResult = adminBiz.callback(callback);
                                logger.info(">>>>>>>>>>> xxl-job callback , CallbackParam:{}, callbackResult:{}", new Object[]{callback.toString(), callbackResult.toString()});
                                if (200 != callbackResult.getCode()) continue;
                                continue block4;
                            }
                            catch (Exception e) {
                                logger.error(">>>>>>>>>>> xxl-job TriggerCallbackThread Exception:", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                    }
                }
            }
        });
        this.triggerCallbackThread.setDaemon(true);
        this.triggerCallbackThread.start();
    }

    public void toStop() {
        this.toStop = true;
    }

    public static void pushCallBack(HandleCallbackParam callback) {
        TriggerCallbackThread.getInstance().callBackQueue.add(callback);
        logger.debug(">>>>>>>>>>> xxl-job, push callback request, logId:{}", (Object)callback.getLogId());
    }
}

