/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.util;

import com.xxl.job.core.rpc.codec.RpcResponse;
import com.xxl.job.core.rpc.serialize.HessianSerializer;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] postRequest(String reqURL, byte[] date) {
        byte[] responseBytes = null;
        HttpPost httpPost = new HttpPost(reqURL);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response;
            HttpEntity entity;
            if (date != null) {
                httpPost.setEntity((HttpEntity)new ByteArrayEntity(date, ContentType.DEFAULT_BINARY));
            }
            if (null != (entity = (response = httpClient.execute((HttpUriRequest)httpPost)).getEntity())) {
                responseBytes = EntityUtils.toByteArray((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            RpcResponse rpcResponse = new RpcResponse();
            rpcResponse.setError(e.getMessage());
            responseBytes = HessianSerializer.serialize(rpcResponse);
        }
        finally {
            httpPost.releaseConnection();
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseBytes;
    }

    public static final byte[] readBytes(HttpServletRequest request) throws IOException {
        request.setCharacterEncoding("UTF-8");
        int contentLen = request.getContentLength();
        ServletInputStream is = request.getInputStream();
        if (contentLen > 0) {
            int readLengthThisTime = 0;
            byte[] message = new byte[contentLen];
            try {
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return message;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new byte[0];
    }
}

