/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.hibernate;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.yammer.dropwizard.hibernate.UnitOfWork;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class UnitOfWorkRequestDispatcher
implements RequestDispatcher {
    private final UnitOfWork unitOfWork;
    private final RequestDispatcher dispatcher;
    private final SessionFactory sessionFactory;

    public UnitOfWorkRequestDispatcher(UnitOfWork unitOfWork, RequestDispatcher dispatcher, SessionFactory sessionFactory) {
        this.unitOfWork = unitOfWork;
        this.dispatcher = dispatcher;
        this.sessionFactory = sessionFactory;
    }

    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public RequestDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Object resource, HttpContext context) {
        Session session = this.sessionFactory.openSession();
        try {
            this.configureSession(session);
            ManagedSessionContext.bind((Session)session);
            this.beginTransaction(session);
            try {
                this.dispatcher.dispatch(resource, context);
                this.commitTransaction(session);
            }
            catch (Exception e) {
                this.rollbackTransaction(session);
                this.rethrow(e);
            }
        }
        finally {
            session.close();
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    private void beginTransaction(Session session) {
        if (this.unitOfWork.transactional()) {
            session.beginTransaction();
        }
    }

    private void configureSession(Session session) {
        session.setDefaultReadOnly(this.unitOfWork.readOnly());
        session.setCacheMode(this.unitOfWork.cacheMode());
        session.setFlushMode(this.unitOfWork.flushMode());
    }

    private void rollbackTransaction(Session session) {
        Transaction txn;
        if (this.unitOfWork.transactional() && (txn = session.getTransaction()) != null && txn.isActive()) {
            txn.rollback();
        }
    }

    private void commitTransaction(Session session) {
        Transaction txn;
        if (this.unitOfWork.transactional() && (txn = session.getTransaction()) != null && txn.isActive()) {
            txn.commit();
        }
    }

    private <E extends Exception> void rethrow(Exception e) throws E {
        throw e;
    }
}

