/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.log4j;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class InstrumentedAppender
extends AppenderSkeleton {
    private final Meter all;
    private final Meter trace;
    private final Meter debug;
    private final Meter info;
    private final Meter warn;
    private final Meter error;
    private final Meter fatal;

    public InstrumentedAppender() {
        this(Metrics.defaultRegistry());
    }

    public InstrumentedAppender(MetricsRegistry registry) {
        this.all = registry.newMeter(Appender.class, "all", "statements", TimeUnit.SECONDS);
        this.trace = registry.newMeter(Appender.class, "trace", "statements", TimeUnit.SECONDS);
        this.debug = registry.newMeter(Appender.class, "debug", "statements", TimeUnit.SECONDS);
        this.info = registry.newMeter(Appender.class, "info", "statements", TimeUnit.SECONDS);
        this.warn = registry.newMeter(Appender.class, "warn", "statements", TimeUnit.SECONDS);
        this.error = registry.newMeter(Appender.class, "error", "statements", TimeUnit.SECONDS);
        this.fatal = registry.newMeter(Appender.class, "fatal", "statements", TimeUnit.SECONDS);
    }

    protected void append(LoggingEvent event) {
        this.all.mark();
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark();
                break;
            }
            case 10000: {
                this.debug.mark();
                break;
            }
            case 20000: {
                this.info.mark();
                break;
            }
            case 30000: {
                this.warn.mark();
                break;
            }
            case 40000: {
                this.error.mark();
                break;
            }
            case 50000: {
                this.fatal.mark();
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

