/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

public class NumericUtils {
    private static Number calculate(Number a, Number b, LongCalculation longCalculation, DoubleCalculation doubleCalculation) {
        if (a instanceof Double || b instanceof Double) {
            return doubleCalculation.apply(a.doubleValue(), b.doubleValue());
        }
        if (a instanceof Float || b instanceof Float) {
            double result = doubleCalculation.apply(a.doubleValue(), b.doubleValue());
            return Float.valueOf((float)result);
        }
        if (a instanceof Long || b instanceof Long) {
            return longCalculation.apply(a.longValue(), b.longValue());
        }
        if (a instanceof Integer || b instanceof Integer) {
            long result = longCalculation.apply(a.longValue(), b.longValue());
            int intResult = (int)result;
            if ((long)intResult == result) {
                return intResult;
            }
            return result;
        }
        if (a instanceof Short || b instanceof Short) {
            long result = longCalculation.apply(a.longValue(), b.longValue());
            short shortResult = (short)result;
            if ((long)shortResult == result) {
                return shortResult;
            }
            return result;
        }
        throw new UnsupportedOperationException("cannot calculate on " + a + " and " + b);
    }

    public static Number addNumbers(Number one, Number other) {
        return NumericUtils.calculate(one, other, Long::sum, Double::sum);
    }

    public static Number subtractNumbers(Number one, Number other) {
        return NumericUtils.calculate(one, other, (a, b) -> a - b, (a, b) -> a - b);
    }

    public static Number multiplyNumbers(Number one, Number other) {
        return NumericUtils.calculate(one, other, (a, b) -> a * b, (a, b) -> a * b);
    }

    @FunctionalInterface
    public static interface LongCalculation {
        public long apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface DoubleCalculation {
        public double apply(double var1, double var3);
    }
}

