/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.MongoSilentServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.ReplyFlag;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseHandler
extends SimpleChannelInboundHandler<ClientRequest> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private final AtomicInteger idSequence = new AtomicInteger();
    private final MongoBackend mongoBackend;
    private final ChannelGroup channelGroup;
    private final long started;

    public MongoDatabaseHandler(MongoBackend mongoBackend, ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        this.mongoBackend = mongoBackend;
        this.started = System.nanoTime();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelGroup.add((Object)ctx.channel());
        log.info("client {} connected", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.info("channel {} closed", (Object)ctx.channel());
        this.channelGroup.remove((Object)ctx.channel());
        this.mongoBackend.handleClose(ctx.channel());
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ClientRequest object) throws Exception {
        if (object instanceof MongoQuery) {
            ctx.channel().writeAndFlush((Object)this.handleQuery((MongoQuery)object));
        } else if (object instanceof MongoInsert) {
            MongoInsert insert = (MongoInsert)object;
            this.mongoBackend.handleInsert(insert);
        } else if (object instanceof MongoDelete) {
            MongoDelete delete = (MongoDelete)object;
            this.mongoBackend.handleDelete(delete);
        } else if (object instanceof MongoUpdate) {
            MongoUpdate update = (MongoUpdate)object;
            this.mongoBackend.handleUpdate(update);
        } else {
            throw new MongoServerException("unknown message: " + object);
        }
    }

    private MongoReply handleQuery(MongoQuery query) {
        MessageHeader header = new MessageHeader(this.idSequence.incrementAndGet(), query.getHeader().getRequestID());
        try {
            ArrayList<Document> documents = new ArrayList<Document>();
            if (query.getCollectionName().startsWith("$cmd")) {
                documents.add(this.handleCommand(query));
            } else {
                for (Document obj : this.mongoBackend.handleQuery(query)) {
                    documents.add(obj);
                }
            }
            return new MongoReply(header, documents, new ReplyFlag[0]);
        }
        catch (NoSuchCommandException e) {
            log.error("unknown command: {}", (Object)query, (Object)e);
            Map<String, Document> additionalInfo = Collections.singletonMap("bad cmd", query.getQuery());
            return this.queryFailure(header, e, additionalInfo);
        }
        catch (MongoSilentServerException e) {
            return this.queryFailure(header, e);
        }
        catch (MongoServerException e) {
            log.error("failed to handle query {}", (Object)query, (Object)e);
            return this.queryFailure(header, e);
        }
    }

    private MongoReply queryFailure(MessageHeader header, MongoServerException exception) {
        Map additionalInfo = Collections.emptyMap();
        return this.queryFailure(header, exception, additionalInfo);
    }

    private MongoReply queryFailure(MessageHeader header, MongoServerException exception, Map<String, ?> additionalInfo) {
        Document obj = new Document();
        obj.put("$err", (Object)exception.getMessageWithoutErrorCode());
        obj.put("errmsg", (Object)exception.getMessageWithoutErrorCode());
        if (exception instanceof MongoServerError) {
            MongoServerError error = (MongoServerError)exception;
            obj.put("code", (Object)error.getCode());
            obj.putIfNotNull("codeName", error.getCodeName());
        }
        obj.putAll((Map<? extends String, ?>)additionalInfo);
        obj.put("ok", (Object)0);
        return new MongoReply(header, obj, ReplyFlag.QUERY_FAILURE);
    }

    Document handleCommand(MongoQuery query) {
        String collectionName = query.getCollectionName();
        if (collectionName.equals("$cmd.sys.inprog")) {
            Collection<Document> currentOperations = this.mongoBackend.getCurrentOperations(query);
            return new Document("inprog", currentOperations);
        }
        if (collectionName.equals("$cmd")) {
            String command;
            switch (command = query.getQuery().keySet().iterator().next()) {
                case "serverStatus": {
                    return this.getServerStatus();
                }
                case "ping": {
                    Document response = new Document();
                    Utils.markOkay(response);
                    return response;
                }
            }
            Document actualQuery = query.getQuery();
            if (command.equals("$query")) {
                command = ((Document)query.getQuery().get("$query")).keySet().iterator().next();
                actualQuery = (Document)actualQuery.get("$query");
            }
            return this.mongoBackend.handleCommand(query.getChannel(), query.getDatabaseName(), command, actualQuery);
        }
        throw new MongoServerException("unknown collection: " + collectionName);
    }

    private Document getServerStatus() {
        Document serverStatus = new Document();
        try {
            serverStatus.put("host", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new MongoServerException("failed to get hostname", e);
        }
        serverStatus.put("version", (Object)Utils.join(this.mongoBackend.getVersion(), "."));
        serverStatus.put("process", (Object)"java");
        serverStatus.put("pid", (Object)this.getProcessId());
        serverStatus.put("uptime", (Object)((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.started)));
        serverStatus.put("uptimeMillis", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.started));
        serverStatus.put("localTime", (Object)Instant.now(this.mongoBackend.getClock()));
        Document connections = new Document();
        connections.put("current", (Object)this.channelGroup.size());
        serverStatus.put("connections", (Object)connections);
        Document cursors = new Document();
        cursors.put("totalOpen", (Object)0);
        serverStatus.put("cursors", (Object)cursors);
        Utils.markOkay(serverStatus);
        return serverStatus;
    }

    private Integer getProcessId() {
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        if (runtimeName.contains("@")) {
            return Integer.valueOf(runtimeName.substring(0, runtimeName.indexOf(64)));
        }
        return 0;
    }
}

