/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.controller;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.service.ApplicationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RegistryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryController.class);
    @Autowired
    private ApplicationRegistry registry;

    @RequestMapping(value={"/api/applications"}, method={RequestMethod.POST})
    public Application register(@RequestBody Application app) {
        LOGGER.info("Register application with ID '{}' and URL '{}'", (Object)app.getId(), (Object)app.getUrl());
        return this.registry.register(app);
    }

    @RequestMapping(value={"/api/application/{id}"}, method={RequestMethod.GET})
    public Application get(@PathVariable String id) {
        LOGGER.debug("Deliver registered application with ID '{}'", (Object)id);
        return this.registry.getApplication(id);
    }

    @RequestMapping(value={"/api/applications"}, method={RequestMethod.GET})
    public List<Application> applications() {
        LOGGER.debug("Deliver all registered applications");
        return this.registry.getApplications();
    }
}

