/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.service;

import de.codecentric.boot.admin.model.Application;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class ApplicationRegistry {
    private final Map<String, Application> registry = new HashMap<String, Application>();

    public Application register(Application app) {
        Validate.notNull((Object)app, (String)"Application must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)app.getId(), (String)"ID must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)app.getUrl(), (String)"URL must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.checkUrl(app.getUrl()), (String)"URL is not valid", (Object[])new Object[0]);
        return this.registry.put(app.getId(), app);
    }

    private boolean checkUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public boolean isRegistered(String id) {
        return this.registry.containsKey(id);
    }

    public List<Application> getApplications() {
        return new ArrayList<Application>(this.registry.values());
    }

    public Application getApplication(String id) {
        if (!this.isRegistered(id)) {
            throw new IllegalArgumentException("Application with ID " + id + " is not registered");
        }
        return this.registry.get(id);
    }
}

