/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ApplicationDiscoveryListener
implements ApplicationListener<ApplicationEvent> {
    private final DiscoveryClient discoveryClient;
    private final ApplicationRegistry registry;
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private String managementContextPath = "";

    public ApplicationDiscoveryListener(DiscoveryClient discoveryClient, ApplicationRegistry registry) {
        this.discoveryClient = discoveryClient;
        this.registry = registry;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof InstanceRegisteredEvent) {
            this.discover();
        } else if (event instanceof ParentHeartbeatEvent) {
            ParentHeartbeatEvent e = (ParentHeartbeatEvent)event;
            this.discoverIfNeeded(e.getValue());
        } else if (event instanceof HeartbeatEvent) {
            HeartbeatEvent e = (HeartbeatEvent)event;
            this.discoverIfNeeded(e.getValue());
        }
    }

    private void discoverIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.discover();
        }
    }

    public void discover() {
        for (String serviceId : this.discoveryClient.getServices()) {
            for (ServiceInstance instance : this.discoveryClient.getInstances(serviceId)) {
                this.registry.register(this.convert(instance));
            }
        }
    }

    private Application convert(ServiceInstance instance) {
        String url = instance.getUri().resolve(this.managementContextPath.startsWith("/") ? this.managementContextPath : "/" + this.managementContextPath).toString();
        return new Application(url, instance.getServiceId());
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }
}

