/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.LinkedHashMap;
import org.springframework.cloud.netflix.zuul.filters.ProxyRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;

public class ApplicationRouteLocator
extends ProxyRouteLocator {
    private ApplicationRegistry registry;
    private String prefix;

    public ApplicationRouteLocator(String servletPath, ApplicationRegistry registry, ZuulProperties properties, String prefix) {
        super(servletPath, null, properties);
        this.registry = registry;
        this.prefix = prefix;
    }

    protected LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap locateRoutes = super.locateRoutes();
        if (this.registry != null) {
            for (Application application : this.registry.getApplications()) {
                String key = this.prefix + "/" + application.getId() + "/*/**";
                locateRoutes.put(key, new ZuulProperties.ZuulRoute(key, application.getUrl()));
            }
        }
        return locateRoutes;
    }
}

