/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.client.RestTemplate;

public class SlackNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "*#{application.name}* (#{application.id}) is *#{to.status}*";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI webhookUrl;
    private String channel;
    private String icon;
    private String username = "Spring Boot Admin";
    private Expression message = this.parser.parseExpression("*#{application.name}* (#{application.id}) is *#{to.status}*", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void doNotify(ClientApplicationStatusChangedEvent event) throws Exception {
        this.restTemplate.postForEntity(this.webhookUrl, this.createMessage(event), Void.class);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setWebhookUrl(URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setMessage(Expression message) {
        this.message = message;
    }

    private Object createMessage(ClientApplicationStatusChangedEvent event) {
        HashMap<String, Object> messageJson = new HashMap<String, Object>();
        messageJson.put("username", this.username);
        if (this.icon != null) {
            messageJson.put("icon_emoji", ":" + this.icon + ":");
        }
        if (this.channel != null) {
            messageJson.put("channel", this.channel);
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>();
        attachments.put("text", this.getText(event));
        attachments.put("color", this.getColor(event));
        attachments.put("mrkdwn_in", Collections.singletonList("text"));
        messageJson.put("attachments", Collections.singletonList(attachments));
        return messageJson;
    }

    private String getText(ClientApplicationStatusChangedEvent event) {
        return (String)this.message.getValue((Object)event, String.class);
    }

    private String getColor(ClientApplicationStatusChangedEvent event) {
        return "UP".equals(event.getTo().getStatus()) ? "good" : "danger";
    }
}

